/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.PropertyCache;

public class FixedLength
extends LengthProperty {
    private static final PropertyCache cache = new PropertyCache();
    private int millipoints;

    private FixedLength(double numUnits, String units) {
        this.convert(numUnits, units);
    }

    public static FixedLength getInstance(double numUnits, String units) {
        return (FixedLength)cache.fetch(new FixedLength(numUnits, units));
    }

    public FixedLength(int baseUnits) {
        this.millipoints = baseUnits;
    }

    protected void convert(double dvalue, String unit) {
        boolean assumedResolution = true;
        if (unit.equals("in")) {
            dvalue *= 72.0;
        } else if (unit.equals("cm")) {
            dvalue *= 28.3464567;
        } else if (unit.equals("mm")) {
            dvalue *= 2.83464567;
        } else if (!unit.equals("pt") && !unit.equals("mpt")) {
            if (unit.equals("pc")) {
                dvalue *= 12.0;
            } else if (unit.equals("px")) {
                dvalue *= (double)assumedResolution;
            } else {
                dvalue = 0.0;
                log.error("Unknown length unit '" + unit + "'");
            }
        }
        this.millipoints = unit.equals("mpt") ? (int)dvalue : (int)(dvalue * 1000.0);
    }

    public int getValue() {
        return this.millipoints;
    }

    public int getValue(PercentBaseContext context) {
        return this.millipoints;
    }

    public double getNumericValue() {
        return this.millipoints;
    }

    public double getNumericValue(PercentBaseContext context) {
        return this.millipoints;
    }

    public boolean isAbsolute() {
        return true;
    }

    public String toString() {
        return this.millipoints + "mpt";
    }

    public boolean equals(Object obj) {
        if (obj instanceof FixedLength) {
            return ((FixedLength)obj).millipoints == this.millipoints;
        }
        return false;
    }

    public int hashCode() {
        return this.millipoints;
    }
}

