/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.xml.sax.Locator;

public class ExternalGraphic
extends AbstractGraphics {
    private String src;
    private String url;
    private int intrinsicWidth;
    private int intrinsicHeight;
    private Length intrinsicAlignmentAdjust;

    public ExternalGraphic(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.src = pList.get(210).getString();
        this.url = ImageFactory.getURL(this.getSrc());
        FOUserAgent userAgent = this.getUserAgent();
        ImageFactory fact = userAgent.getFactory().getImageFactory();
        FopImage fopimage = fact.getImage(this.url, userAgent);
        if (fopimage == null) {
            log.error("Image not available: " + this.getSrc());
        } else {
            if (!fopimage.load(1)) {
                log.error("Cannot read image dimensions: " + this.getSrc());
            }
            this.intrinsicWidth = fopimage.getIntrinsicWidth();
            this.intrinsicHeight = fopimage.getIntrinsicHeight();
            this.intrinsicAlignmentAdjust = fopimage.getIntrinsicAlignmentAdjust();
        }
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().image(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public String getSrc() {
        return this.src;
    }

    public String getURL() {
        return this.url;
    }

    public String getLocalName() {
        return "external-graphic";
    }

    public int getNameId() {
        return 9;
    }

    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public Length getIntrinsicAlignmentAdjust() {
        return this.intrinsicAlignmentAdjust;
    }
}

