/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.versionkit;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.metainf.jira.plugin.versionkit.AppVersionManager;
import com.metainf.jira.plugin.versionkit.VersionKit;

public class AppVersionManagerImpl
implements AppVersionManager {
    private BuildUtilsInfo buildUtilsInfo;
    private final VersionKit.SoftwareVersion JIRA_VERSION;
    private final VersionKit.SoftwareVersion JIRA60_VERSION = VersionKit.version(6, 0);
    private final VersionKit.SoftwareVersion JIRA61_VERSION = VersionKit.version(6, 1);
    private final VersionKit.SoftwareVersion JIRA62_VERSION = VersionKit.version(6, 2);
    private final VersionKit.SoftwareVersion JIRA64_VERSION = VersionKit.version(6, 4);
    private final boolean BEFORE_JIRA6;
    private final boolean JIRA61_OR_GREATER;
    private final boolean JIRA62_OR_GREATER;
    private final boolean JIRA64_OR_GREATER;
    private final String VERSION_NUMBER;

    public AppVersionManagerImpl() {
        this.buildUtilsInfo = (BuildUtilsInfo)ComponentAccessor.getComponentOfType(BuildUtilsInfo.class);
        this.JIRA_VERSION = VersionKit.parse(this.buildUtilsInfo.getVersion());
        this.BEFORE_JIRA6 = this.JIRA_VERSION != null && this.JIRA_VERSION.isLessThan(this.JIRA60_VERSION);
        this.JIRA61_OR_GREATER = this.JIRA_VERSION != null && this.JIRA_VERSION.isGreaterThanOrEqualTo(this.JIRA61_VERSION);
        this.JIRA62_OR_GREATER = this.JIRA_VERSION != null && this.JIRA_VERSION.isGreaterThanOrEqualTo(this.JIRA62_VERSION);
        boolean bl = this.JIRA64_OR_GREATER = this.JIRA_VERSION != null && this.JIRA_VERSION.isGreaterThanOrEqualTo(this.JIRA64_VERSION);
        this.VERSION_NUMBER = this.isJira62OrLater() ? "62" : (this.isJira61OrLater() ? "61" : "");
    }

    public AppVersionManagerImpl(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.JIRA_VERSION = VersionKit.parse(buildUtilsInfo.getVersion());
        this.BEFORE_JIRA6 = this.JIRA_VERSION != null && this.JIRA_VERSION.isLessThan(this.JIRA60_VERSION);
        this.JIRA61_OR_GREATER = this.JIRA_VERSION != null && this.JIRA_VERSION.isGreaterThanOrEqualTo(this.JIRA61_VERSION);
        this.JIRA62_OR_GREATER = this.JIRA_VERSION != null && this.JIRA_VERSION.isGreaterThanOrEqualTo(this.JIRA62_VERSION);
        boolean bl = this.JIRA64_OR_GREATER = this.JIRA_VERSION != null && this.JIRA_VERSION.isGreaterThanOrEqualTo(this.JIRA64_VERSION);
        this.VERSION_NUMBER = this.isJira62OrLater() ? "62" : (this.isJira61OrLater() ? "61" : "");
    }

    @Override
    public VersionKit.SoftwareVersion getApplicationVersion() {
        return null;
    }

    @Override
    public boolean isBeforeJira6() {
        return this.BEFORE_JIRA6;
    }

    @Override
    public boolean isJira61OrLater() {
        return this.JIRA61_OR_GREATER;
    }

    @Override
    public boolean isJira62OrLater() {
        return this.JIRA62_OR_GREATER;
    }

    @Override
    public boolean isJira64OrLater() {
        return this.JIRA64_OR_GREATER;
    }

    @Override
    public String getVersionNumber() {
        return this.VERSION_NUMBER;
    }
}

