/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.workflow;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilFactory;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class IssueTransitionerImpl
implements IssueTransitioner {
    private Logger logger = Logger.getLogger(this.getClass());
    private final WorkflowManager workflowManager;
    private final WorkflowTransitionUtilFactory workflowTransitionUtilFactory;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;

    public IssueTransitionerImpl(WorkflowManager workflowManager, WorkflowTransitionUtilFactory workflowTransitionUtilFactory, IssueManager issueManager, JiraAuthenticationContext authenticationContext) {
        this.workflowManager = workflowManager;
        this.workflowTransitionUtilFactory = workflowTransitionUtilFactory;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public List<ActionDescriptor> getAllTransitions(Issue issue) {
        ArrayList<ActionDescriptor> actions2 = new ArrayList<ActionDescriptor>();
        try {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
            Status status = issue.getStatus();
            List issueActions = workflow.getLinkedStep(status).getActions();
            if (issueActions != null) {
                actions2.addAll(issueActions);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return actions2;
    }

    @Override
    public List<ActionDescriptor> getTransitions(Issue issue, String transitionProperty, String transitionPropertyValue) {
        LinkedList<ActionDescriptor> actions2 = new LinkedList<ActionDescriptor>();
        try {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
            actions2.addAll(this.getActionsByProperty(workflow, this.getAllTransitions(issue), transitionProperty, transitionPropertyValue, false));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return actions2;
    }

    @Override
    public void transitionIssue(Issue issue, ApplicationUser defaultTransitioningUser) {
        this.transitionIssue(issue, "jeti.on.email.transition", null, defaultTransitioningUser);
    }

    @Override
    public void transitionIssue(Issue issue, String nameOfTheTransition, ApplicationUser defaultTransitioningUser) {
        try {
            Status status;
            Collection issueActions;
            if (StringUtils.isBlank((CharSequence)nameOfTheTransition)) {
                return;
            }
            JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
            ActionDescriptor actionByName = this.getActionByName(workflow, issueActions = workflow.getLinkedStep(status = issue.getStatus()).getActions(), nameOfTheTransition, false);
            if (actionByName == null) {
                issueActions = workflow.getAllActions();
                actionByName = this.getActionByName(workflow, issueActions, nameOfTheTransition, true);
            }
            if (actionByName != null) {
                this.logger.debug((Object)("Transition being called: " + nameOfTheTransition));
                this.executeAction(workflow, this.issueManager.getIssueObject(issue.getId()), actionByName, defaultTransitioningUser);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private ActionDescriptor getActionByName(JiraWorkflow workflow, Collection<ActionDescriptor> issueActions, String nameOfTheTransition, boolean globalOnly) {
        ActionDescriptor result = null;
        if (issueActions != null && !issueActions.isEmpty()) {
            for (ActionDescriptor ad : issueActions) {
                if (!ad.getName().equalsIgnoreCase(nameOfTheTransition) || globalOnly && !workflow.isGlobalAction(ad)) continue;
                result = ad;
                break;
            }
        }
        return result;
    }

    private Collection<ActionDescriptor> getActionsByProperty(JiraWorkflow workflow, Collection<ActionDescriptor> issueActions, String transitionProperty, String transitionPropertyValue, boolean globalOnly) {
        LinkedList<ActionDescriptor> result = new LinkedList<ActionDescriptor>();
        if (issueActions != null && !issueActions.isEmpty()) {
            for (ActionDescriptor ad : issueActions) {
                String metaValue;
                Map meta = ad.getMetaAttributes();
                String string = metaValue = meta.get(transitionProperty) == null ? null : meta.get(transitionProperty).toString();
                if (!meta.containsKey(transitionProperty) || transitionPropertyValue != null && !transitionPropertyValue.equalsIgnoreCase(metaValue) || globalOnly && !workflow.isGlobalAction(ad)) continue;
                result.add(ad);
            }
        }
        return result;
    }

    private ActionDescriptor getActionByProperty(JiraWorkflow workflow, Collection<ActionDescriptor> issueActions, String transitionProperty, String transitionPropertyValue, boolean globalOnly) {
        ActionDescriptor result = null;
        if (issueActions != null && !issueActions.isEmpty()) {
            for (ActionDescriptor ad : issueActions) {
                String metaValue;
                Map meta = ad.getMetaAttributes();
                String string = metaValue = meta.get(transitionProperty) == null ? null : meta.get(transitionProperty).toString();
                if (!meta.containsKey(transitionProperty) || transitionPropertyValue != null && !transitionPropertyValue.equalsIgnoreCase(metaValue) || globalOnly && !workflow.isGlobalAction(ad)) continue;
                result = ad;
                break;
            }
        }
        return result;
    }

    @Override
    public void transitionIssue(Issue issue, String transitionProperty, String transitionPropertyValue, ApplicationUser defaultTransitioningUser) {
        try {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
            Status status = issue.getStatus();
            Collection issueActions = workflow.getLinkedStep(status).getActions();
            ActionDescriptor actionByProperty = this.getActionByProperty(workflow, issueActions, transitionProperty, transitionPropertyValue, false);
            if (actionByProperty == null) {
                issueActions = workflow.getAllActions();
                actionByProperty = this.getActionByProperty(workflow, issueActions, transitionProperty, transitionPropertyValue, true);
            }
            if (actionByProperty != null) {
                this.executeAction(workflow, this.issueManager.getIssueObject(issue.getId()), actionByProperty, defaultTransitioningUser);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void executeAction(JiraWorkflow workflow, MutableIssue mutableIssue, ActionDescriptor action, ApplicationUser defaultTransitioningUser) {
        if (action == null) {
            return;
        }
        WorkflowTransitionUtil workflowProgress = this.workflowTransitionUtilFactory.create();
        workflowProgress.setIssue(mutableIssue);
        workflowProgress.setAction(action.getId());
        workflowProgress.setParams(new HashMap());
        if (this.authenticationContext.getLoggedInUser() != null) {
            try {
                workflowProgress.setUserkey(this.authenticationContext.getLoggedInUser().getKey());
                this.workflowManager.doWorkflowAction((WorkflowProgressAware)workflowProgress);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultTransitioningUser != null) {
            try {
                workflowProgress.setUserkey(defaultTransitioningUser.getKey());
                this.workflowManager.doWorkflowAction((WorkflowProgressAware)workflowProgress);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mutableIssue.getReporter() != null) {
            try {
                workflowProgress.setUserkey(mutableIssue.getReporter().getKey());
                this.workflowManager.doWorkflowAction((WorkflowProgressAware)workflowProgress);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

