/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.workflow;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.metainf.jira.plugin.emailissue.action.AddAttachmentType;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.GlobalConfigHelper;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import com.metainf.jira.plugin.emailissue.workflow.VelocityHelper;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

public class EmailThisIssuePostFunctionFactory
extends AbstractWorkflowPluginFactory
implements WorkflowPluginFunctionFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)("com.atlassian." + EmailThisIssuePostFunctionFactory.class.getName()));
    private WorkflowManager workflowManager;
    private ProjectRoleManager projectRoleManager;
    private GroupManager groupManager;
    private CustomFieldManager customFieldManager;
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final SearchService searchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private Authorizer authorizer;
    private ApplicationProperties applicationProperties;
    private ConfigurationManager configurationManager;
    private TemplateDao templateDao;
    private final UserResolver userResolver;

    public EmailThisIssuePostFunctionFactory(ApplicationProperties applicationProperties, CustomFieldManager customFieldManager, WorkflowManager workflowManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, AutoCompleteJsonGenerator autoCompleteJsonGenerator, SearchService searchService, JiraAuthenticationContext jiraAuthenticationContext, Authorizer authorizer, ConfigurationManager configurationManager, TemplateDao templateDao, UserResolver userResolver) {
        this.workflowManager = workflowManager;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.customFieldManager = customFieldManager;
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.searchService = searchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.templateDao = templateDao;
        this.authorizer = authorizer;
        this.applicationProperties = applicationProperties;
        this.configurationManager = configurationManager;
        this.userResolver = userResolver;
    }

    protected void getVelocityParamsForInput(Map<String, Object> velocityParams) {
        Map myParams = ActionContext.getParameters();
        JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflow(((String[])myParams.get("workflowName"))[0]);
        Configuration globalParameters = this.configurationManager.getGlobalConfiguration();
        VelocityHelper vh = new VelocityHelper();
        vh.setBccEnabled(globalParameters.isBccEnabled());
        vh.setUserOptionsEnabled(!globalParameters.isUserOptionsDisabled());
        vh.setEmailIssueTo(globalParameters.getEmailIssueTo());
        vh.setEmailIssueCc(globalParameters.getEmailIssueCc());
        vh.setEmailIssueBcc(globalParameters.getEmailIssueBcc());
        vh.setRecipients(StringUtils.isNotEmpty((String)globalParameters.getRecipients()) ? Arrays.asList(globalParameters.getRecipients().split(",")) : null);
        vh.setCopyrecipients(StringUtils.isNotEmpty((String)globalParameters.getCopyrecipients()) ? Arrays.asList(globalParameters.getCopyrecipients().split(",")) : null);
        vh.setBlindcopyrecipients(StringUtils.isNotEmpty((String)globalParameters.getBlindcopyrecipients()) ? Arrays.asList(globalParameters.getBlindcopyrecipients().split(",")) : null);
        vh.setEmailOptions(new EmailOptions(globalParameters));
        vh.setBypassCommentAllowed(globalParameters.getBypassComment() == 1);
        vh.setI18n(((JiraAuthenticationContext)ComponentManager.getComponentInstanceOfType(JiraAuthenticationContext.class)).getI18nHelper());
        ArrayList<ProjectRole> roles = new ArrayList<ProjectRole>(this.projectRoleManager.getProjectRoles());
        GlobalConfigHelper.excludeRoles(globalParameters, roles);
        vh.setUserRoles(roles);
        ArrayList<Group> groups = new ArrayList<Group>(this.userResolver.getAllUserGroups());
        GlobalConfigHelper.excludeGroups(globalParameters, groups);
        HashSet<String> groupNames = new HashSet<String>(groups.size());
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        vh.setUserGroups(groupNames);
        List<CustomField> fields = this.getCustomFields();
        GlobalConfigHelper.excludeFields(globalParameters, fields);
        vh.setCustomFields(fields);
        vh.setTemplates(Arrays.asList(this.templateDao.findAll("NAME")));
        velocityParams.put("action", vh);
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        velocityParams.put("baseUrl", baseUrl);
        try {
            velocityParams.put("visibleFieldNamesJson", this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(this.jiraAuthenticationContext.getLoggedInUser(), this.jiraAuthenticationContext.getLocale()));
            velocityParams.put("visibleFunctionNamesJson", this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(this.jiraAuthenticationContext.getLoggedInUser(), this.jiraAuthenticationContext.getLocale()));
            velocityParams.put("jqlReservedWordsJson", this.autoCompleteJsonGenerator.getJqlReservedWordsJson());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected void getVelocityParamsForEdit(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        FunctionDescriptor fd = (FunctionDescriptor)descriptor;
        this.getVelocityParamsForInput(velocityParams);
        VelocityHelper vh = (VelocityHelper)velocityParams.get("action");
        if (!this.authorizer.authorize().isValid()) {
            logger.warn("EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            vh.setLicenseValid(false);
        } else {
            vh.setLicenseValid(true);
        }
        EmailOptions options = new EmailOptions(fd.getArgs());
        vh.setEmailOptions(options);
        vh.setEmailIssueTo((String)fd.getArgs().get("emailIssueTo"));
        vh.setEmailIssueCc((String)fd.getArgs().get("emailIssueCc"));
        vh.setEmailIssueBcc((String)fd.getArgs().get("emailIssueBcc"));
        vh.setEmailIssueSubject((String)fd.getArgs().get("emailIssueSubject"));
        vh.setEmailIssueBody((String)fd.getArgs().get("emailIssueBody"));
        String addAttachments = (String)fd.getArgs().get("addAttachments");
        vh.setAddAttachments(StringUtils.isBlank((String)addAttachments) ? AddAttachmentType.NONE.name() : addAttachments);
        vh.setIncludeComment(Boolean.valueOf((String)fd.getArgs().get("includeComment")));
        String templateId = (String)fd.getArgs().get("emailIssueTemplate");
        vh.setTemplateId(StringUtils.isNotBlank((String)templateId) ? new Integer(templateId) : null);
        if (StringUtils.isNotEmpty((String)((String)fd.getArgs().get("recipients")))) {
            vh.setRecipients(Arrays.asList(((String)fd.getArgs().get("recipients")).split(",")));
        } else {
            vh.setRecipients(Collections.EMPTY_LIST);
        }
        if (StringUtils.isNotEmpty((String)((String)fd.getArgs().get("copyrecipients")))) {
            vh.setCopyrecipients(Arrays.asList(((String)fd.getArgs().get("copyrecipients")).split(",")));
        } else {
            vh.setCopyrecipients(Collections.EMPTY_LIST);
        }
        if (StringUtils.isNotEmpty((String)((String)fd.getArgs().get("blindcopyrecipients")))) {
            vh.setBlindcopyrecipients(Arrays.asList(((String)fd.getArgs().get("blindcopyrecipients")).split(",")));
        } else {
            vh.setBlindcopyrecipients(Collections.EMPTY_LIST);
        }
        vh.setFilter((String)fd.getArgs().get("filter"));
    }

    private List<CustomField> getCustomFields() {
        List<CustomField> fields = CustomFieldUtil.filterFields(this.configurationManager.getGlobalConfiguration(), new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects()));
        return fields;
    }

    protected void getVelocityParamsForView(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        String jqlError;
        String addAttachments;
        Template template;
        if (!this.authorizer.authorize().isValid()) {
            logger.warn("EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            velocityParams.put("licenseValid", Boolean.FALSE);
        } else {
            velocityParams.put("licenseValid", Boolean.TRUE);
        }
        FunctionDescriptor fd = (FunctionDescriptor)descriptor;
        velocityParams.put("jqlFilter", (String)fd.getArgs().get("filter"));
        String templateId = (String)fd.getArgs().get("emailIssueTemplate");
        if (StringUtils.isNotBlank((String)templateId) && (template = (Template)this.templateDao.getById(Long.parseLong(templateId))) != null) {
            velocityParams.put("template", template);
        }
        StringBuilder to = new StringBuilder();
        if (StringUtils.isNotBlank((String)((String)fd.getArgs().get("emailIssueTo")))) {
            to.append((String)fd.getArgs().get("emailIssueTo"));
        }
        if (StringUtils.isNotEmpty((String)((String)fd.getArgs().get("recipients")))) {
            this.toString(to, ((String)fd.getArgs().get("recipients")).split(","));
        }
        if (to.length() > 0) {
            velocityParams.put("emailIssueTo", to.toString());
        }
        StringBuilder cc = new StringBuilder();
        if (StringUtils.isNotBlank((String)((String)fd.getArgs().get("emailIssueCc")))) {
            cc.append((String)fd.getArgs().get("emailIssueCc"));
        }
        if (StringUtils.isNotEmpty((String)((String)fd.getArgs().get("copyrecipients")))) {
            this.toString(cc, ((String)fd.getArgs().get("copyrecipients")).split(","));
        }
        if (cc.length() > 0) {
            velocityParams.put("emailIssueCc", cc.toString());
        }
        StringBuilder bcc = new StringBuilder();
        if (StringUtils.isNotBlank((String)((String)fd.getArgs().get("emailIssueBcc")))) {
            bcc.append((String)fd.getArgs().get("emailIssueBcc"));
        }
        if (StringUtils.isNotEmpty((String)((String)fd.getArgs().get("blindcopyrecipients")))) {
            this.toString(bcc, ((String)fd.getArgs().get("blindcopyrecipients")).split(","));
        } else {
            velocityParams.put("blindcopyrecipients", Collections.EMPTY_LIST);
        }
        if (bcc.length() > 0) {
            velocityParams.put("emailIssuebcc", bcc.toString());
        }
        if (StringUtils.isNotBlank((String)((String)fd.getArgs().get("emailIssueSubject")))) {
            velocityParams.put("emailIssueSubject", (String)fd.getArgs().get("emailIssueSubject"));
        }
        if (StringUtils.isNotBlank((String)((String)fd.getArgs().get("emailIssueBody")))) {
            velocityParams.put("emailIssueBody", (String)fd.getArgs().get("emailIssueBody"));
        }
        velocityParams.put("addAttachments", StringUtils.isBlank((String)(addAttachments = (String)fd.getArgs().get("addAttachments"))) ? AddAttachmentType.NONE.name() : addAttachments);
        EmailOptions options = new EmailOptions(fd.getArgs());
        velocityParams.put("emailOptions", options);
        velocityParams.put("includeComment", (boolean)Boolean.valueOf((String)fd.getArgs().get("includeComment")));
        String jql = (String)fd.getArgs().get("filter");
        if (StringUtils.isNotBlank((String)jql)) {
            velocityParams.put("jqlCriteria", jql);
        }
        if (StringUtils.isNotBlank((String)(jqlError = (String)fd.getArgs().get("filterErrors")))) {
            velocityParams.put("jqlError", jqlError);
        }
    }

    public Map<String, ?> getDescriptorParams(Map<String, Object> formParams) {
        SearchService.ParseResult pr;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("emailIssueTo", this.extractSingleParam(formParams, "emailIssueTo", ""));
        params.put("emailIssueCc", this.extractSingleParam(formParams, "emailIssueCc", ""));
        params.put("emailIssueBcc", this.extractSingleParam(formParams, "emailIssueBcc", ""));
        if (formParams.get("recipients") == null) {
            params.put("recipients", "");
        } else {
            params.put("recipients", this.toString((String[])formParams.get("recipients")));
        }
        if (formParams.get("copyrecipients") == null) {
            params.put("copyrecipients", "");
        } else {
            params.put("copyrecipients", this.toString((String[])formParams.get("copyrecipients")));
        }
        if (formParams.get("blindcopyrecipients") == null) {
            params.put("blindcopyrecipients", "");
        } else {
            params.put("blindcopyrecipients", this.toString((String[])formParams.get("blindcopyrecipients")));
        }
        params.put("emailIssueSubject", this.extractSingleParam(formParams, "emailIssueSubject", ""));
        params.put("emailIssueBody", this.extractSingleParam(formParams, "emailIssueBody", ""));
        params.put("addAttachments", this.extractSingleParam(formParams, "addAttachments", AddAttachmentType.NONE.name()));
        params.put("includeComment", this.extractSingleParam(formParams, "includeComment", "false"));
        params.put("emailIssueTemplate", this.extractSingleParam(formParams, "emailIssueTemplate", ""));
        params.put(EmailOptions.Option.ADD_2_WATCHERS.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.ADD_2_WATCHERS.getAttributeName(), "false"));
        params.put(EmailOptions.Option.ADD_COMMENTS.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.ADD_COMMENTS.getAttributeName(), "false"));
        params.put(EmailOptions.Option.BYPASS_COMMENT.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.BYPASS_COMMENT.getAttributeName(), "false"));
        params.put(EmailOptions.Option.COMMENT_VISIBILITY.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.COMMENT_VISIBILITY.getAttributeName(), ""));
        params.put(EmailOptions.Option.FORMAT.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.FORMAT.getAttributeName(), "text"));
        params.put(EmailOptions.Option.MAIL_AS_ME.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.MAIL_AS_ME.getAttributeName(), "false"));
        params.put(EmailOptions.Option.REPLY_TO_ME.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.REPLY_TO_ME.getAttributeName(), "false"));
        params.put(EmailOptions.Option.SURPRESS_COMMENT.getAttributeName(), this.extractSingleParam(formParams, EmailOptions.Option.SURPRESS_COMMENT.getAttributeName(), "false"));
        String filter = this.extractSingleParam(formParams, "filter");
        if (StringUtils.isNotBlank((String)filter) && (pr = this.searchService.parseQuery(this.jiraAuthenticationContext.getLoggedInUser(), filter)).getErrors().hasAnyErrors()) {
            params.put("filterErrors", pr.getErrors().getErrorMessages().toString());
        }
        params.put("filter", filter);
        return params;
    }

    private void toString(StringBuilder sb, Object[] values) {
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                String token;
                if (values[i] == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((token = values[i].toString()).startsWith("r:")) {
                    long roleId = Long.parseLong(token.substring(2));
                    ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(roleId));
                    sb.append(projectRole == null ? token : "r:" + projectRole.getName());
                    continue;
                }
                if (token.startsWith("cf:")) {
                    String fieldKey = token.substring(3);
                    CustomField cf = this.customFieldManager.getCustomFieldObject(fieldKey);
                    sb.append(cf == null ? token : "cf:" + cf.getName());
                    continue;
                }
                sb.append(values[i].toString());
            }
        }
    }

    private Object toString(String[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }

    protected String extractSingleParam(Map<String, Object> params, String key, String defaultValue) {
        if (params != null && params.containsKey(key)) {
            return super.extractSingleParam(params, key);
        }
        return defaultValue;
    }
}

