/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.workflow;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.metainf.jira.plugin.emailissue.action.AddAttachmentType;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.listener.IssueEventListener;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.template.Renderer;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.workflow.AsyncPostFunctionExecutor;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailThisIssuePostFunction
extends AbstractJiraFunctionProvider {
    private static final String JQL_PATTERN = "({0}) AND (issuekey={1})";
    private static final Logger log = LoggerFactory.getLogger((String)("com.atlassian." + EmailThisIssuePostFunction.class.getName()));
    public static final String FIELD_RECIPIENTS = "recipients";
    public static final String FIELD_COPY_RECIPIENTS = "copyrecipients";
    public static final String FIELD_BLINDCOPY_RECIPIENTS = "blindcopyrecipients";
    public static final String FIELD_TO = "emailIssueTo";
    public static final String FIELD_CC = "emailIssueCc";
    public static final String FIELD_BCC = "emailIssueBcc";
    public static final String FIELD_SUBJECT = "emailIssueSubject";
    public static final String FIELD_BODY = "emailIssueBody";
    public static final String FIELD_ATTACHMENTS = "addAttachments";
    public static final String FIELD_INCLUDE_COMMENT = "includeComment";
    public static final String FIELD_TEMPLATE = "emailIssueTemplate";
    public static final String FIELD_FILTER = "filter";
    public static final String FIELD_FILTER_ERROR = "filterErrors";
    private EmailSender emailSender;
    private Authorizer authorizer;
    private ConfigurationManager configurationManager;
    private TemplateDao templateDao;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    protected final JiraAuthenticationContext authenticationContext;
    private final IssueSearcher issueSearcher;
    private final CustomFieldManager customFieldManager;
    private final IssueEventListener issueEventListener;

    public EmailThisIssuePostFunction(EmailSender emailBuilder, Authorizer authorizer, ConfigurationManager configurationManager, TemplateDao templateDao, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, JiraAuthenticationContext authenticationContext, IssueSearcher issueSearcher, CustomFieldManager customFieldManager, IssueEventListener issueEventListener) {
        this.authorizer = authorizer;
        this.emailSender = emailBuilder;
        this.configurationManager = configurationManager;
        this.templateDao = templateDao;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.authenticationContext = authenticationContext;
        this.issueSearcher = issueSearcher;
        this.customFieldManager = customFieldManager;
        this.issueEventListener = issueEventListener;
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        MutableIssue issue = this.getIssue(transientVars);
        if (!this.authorizer.authorize().isValid()) {
            log.warn("EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            return;
        }
        try {
            EmailDefinitionImpl emailDefinition = this.buildEmailDefinition(issue, transientVars, args, ps);
            String jqlCondition = (String)args.get(FIELD_FILTER);
            if (StringUtils.isBlank((String)jqlCondition)) {
                this.emailSender.sendEmailAsync(emailDefinition, this.getCallerUser(transientVars, args));
                log.debug("Email sent from post function");
            } else {
                AsyncPostFunctionExecutor asyncPostFunctionExecutor = new AsyncPostFunctionExecutor(this.emailSender, this.issueSearcher, ComponentAccessor.getIssueManager(), ComponentAccessor.getJiraAuthenticationContext(), this.getCallerUser(transientVars, args), emailDefinition, jqlCondition);
                this.issueEventListener.onPostFunction(asyncPostFunctionExecutor);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private EmailDefinitionImpl buildEmailDefinition(MutableIssue issue, Map transientVars, Map args, PropertySet ps) {
        String templateId;
        String comment;
        String emailBody = (String)args.get(FIELD_BODY);
        EmailOptions emailOptions = !this.configurationManager.getGlobalConfiguration().isUserOptionsDisabled() ? new EmailOptions(args) : new EmailOptions(this.configurationManager.getGlobalConfiguration());
        String string = comment = transientVars.get("comment") != null ? transientVars.get("comment").toString() : null;
        if (Boolean.valueOf((String)args.get(FIELD_INCLUDE_COMMENT)).booleanValue() && comment != null) {
            FieldLayoutItem fyi = this.fieldLayoutManager.getFieldLayout((Issue)issue).getFieldLayoutItem("comment");
            if (this.isJEditorRenderer(fyi.getRendererType())) {
                emailOptions.setRichHtml(true);
                emailBody = this.rendererManager.getRenderedContent(Renderer.WIKI.getKey(), emailBody, issue.getIssueRenderContext());
            }
            emailBody = emailBody + comment;
        }
        EmailDefinitionImpl def = new EmailDefinitionImpl((Issue)issue, this.buildRecipients((String)args.get(FIELD_RECIPIENTS)), this.buildRecipients((String)args.get(FIELD_COPY_RECIPIENTS)), this.buildRecipients((String)args.get(FIELD_BLINDCOPY_RECIPIENTS)), emailOptions, emailBody, (String)args.get(FIELD_SUBJECT), this.getCallerUser(transientVars, args), (String)args.get(FIELD_TO), (String)args.get(FIELD_CC), (String)args.get(FIELD_BCC), ((JiraAuthenticationContext)ComponentManager.getComponentInstanceOfType(JiraAuthenticationContext.class)).getI18nHelper(), this.configurationManager.getGlobalConfiguration().getEventId(), EmailSource.WORKFLOW);
        def.setComment(comment);
        def.setCommentObject((Comment)transientVars.get("commentValue"));
        String aatValue = (String)args.get(FIELD_ATTACHMENTS);
        AddAttachmentType addAttachmentType = AddAttachmentType.getByName(aatValue);
        if (addAttachmentType != null) {
            HashSet<Long> uploadedAttachments = new HashSet<Long>();
            if (transientVars.containsKey("changeItems")) {
                List changeItems = (List)transientVars.get("changeItems");
                for (ChangeItemBean changeItem : changeItems) {
                    if (!"Attachment".equalsIgnoreCase(changeItem.getField()) || !StringUtils.isNotBlank((String)changeItem.getTo())) continue;
                    uploadedAttachments.add(Long.parseLong(changeItem.getTo()));
                }
            }
            def.setAttachmentObjects(addAttachmentType.filterAttachments((Issue)issue, uploadedAttachments).toArray(new Attachment[0]));
        }
        if (StringUtils.isNotBlank((String)(templateId = (String)args.get(FIELD_TEMPLATE)))) {
            try {
                Template template = (Template)this.templateDao.getById(Long.parseLong(templateId));
                def.setEmailTemplate(template);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    private List<Recipient> buildRecipients(String value) {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        if (StringUtils.isNotEmpty((String)value)) {
            String[] values = value.split(",");
            for (int i = 0; i < values.length; ++i) {
                recipients.add(new Recipient(values[i], "", Recipient.Type.fromKey(values[i])));
            }
        }
        return recipients;
    }

    protected boolean isJEditorRenderer(String rendererType) {
        return Renderer.JEDITOR.getKey().equalsIgnoreCase(rendererType);
    }
}

