/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.workflow;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AsyncPostFunctionExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(AsyncPostFunctionExecutor.class);
    private final EmailSender emailBuilder;
    private final IssueSearcher issueSearcher;
    private final IssueManager issueManager;
    private final ApplicationUser user;
    private final EmailDefinitionImpl emailDefinition;
    private final String jqlCondition;
    private final JiraAuthenticationContext authenticationContext;

    public AsyncPostFunctionExecutor(EmailSender emailBuilder, IssueSearcher issueSearcher, IssueManager issueManager, JiraAuthenticationContext authenticationContext, ApplicationUser user, EmailDefinitionImpl emailDefinition, String jqlCondition) {
        this.emailBuilder = emailBuilder;
        this.issueSearcher = issueSearcher;
        this.issueManager = issueManager;
        this.user = user;
        this.emailDefinition = emailDefinition;
        this.jqlCondition = jqlCondition;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public void run() {
        try {
            this.authenticationContext.setLoggedInUser(this.user);
            this.execute(true);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.authenticationContext.setLoggedInUser((ApplicationUser)null);
        }
    }

    public void executeSynchronously() {
        try {
            this.execute(false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void execute(boolean reindex) {
        try {
            if (this.emailDefinition != null && StringUtils.isNotBlank((CharSequence)this.jqlCondition)) {
                Issue issueToSendInEmail = this.emailDefinition.getIssueObject();
                if (reindex) {
                    issueToSendInEmail = this.issueManager.getIssueObject(this.emailDefinition.getIssueObject().getId());
                    this.issueSearcher.reIndexIssue(issueToSendInEmail);
                }
                if (this.issueSearcher.issueMatchesJQL(this.jqlCondition, issueToSendInEmail, true)) {
                    this.emailDefinition.setIssue(issueToSendInEmail);
                    this.emailBuilder.sendEmailAsync(this.emailDefinition, this.user);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

