/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StringUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static byte[] normalizeString(String string) {
        try {
            if (string == null) {
                return null;
            }
            String trimmedString = string.trim();
            byte[] byteArray = trimmedString.getBytes(DEFAULT_CHARSET);
            byte[] trimmedByteArray = Arrays.copyOfRange(byteArray, 0, 50);
            return trimmedByteArray;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static byte[] xorMessage(byte[] message, byte[] key) {
        if (message == null || key == null) {
            return null;
        }
        int messageLength = message.length;
        int keyLength = key.length;
        byte[] xoredMessage = new byte[messageLength];
        for (int i = 0; i < messageLength; ++i) {
            xoredMessage[i] = (byte)(message[i] ^ key[i % keyLength]);
        }
        return xoredMessage;
    }

    public static String merge(String commaSeparatedValues, Set<String> values2add, String separator) {
        HashSet<String> newValues = StringUtils.isNotBlank((String)commaSeparatedValues) ? new HashSet<String>(Arrays.asList(commaSeparatedValues.toLowerCase().split(separator))) : new HashSet();
        for (String value2add : values2add) {
            newValues.add(value2add.toLowerCase());
        }
        return StringUtils.join(newValues, (String)separator);
    }

    public static String sanitize(String s) {
        return StringUtils.isBlank((String)s) ? null : s.replaceAll("[^\b-\uffff]", "");
    }

    public static String replaceInTags(String htmlTag, String text, String searchString, String replacement) {
        if (StringUtils.isEmpty((String)text) || StringUtils.isEmpty((String)searchString) || replacement == null) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder(text);
        int tagOpenPos = stringBuilder.indexOf(htmlTag);
        while (tagOpenPos > -1) {
            int tagClosePos = stringBuilder.indexOf(">", tagOpenPos);
            if (tagClosePos > tagOpenPos) {
                String substring = stringBuilder.substring(tagOpenPos, Math.min(stringBuilder.length(), tagClosePos + 1));
                substring = StringUtils.replace((String)substring, (String)searchString, (String)replacement);
                stringBuilder.replace(tagOpenPos, Math.min(stringBuilder.length(), tagClosePos + 1), substring);
            }
            tagOpenPos = stringBuilder.indexOf(htmlTag, tagOpenPos + replacement.length());
        }
        return stringBuilder.toString();
    }

    public static String removeScripts(String htmlString) {
        if (htmlString == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(htmlString);
        int i = sb.indexOf("<script");
        while (i > -1) {
            int j = sb.indexOf("</script>", i + 1);
            if (j > i) {
                sb.replace(i, j + 9, "");
            }
            i = sb.indexOf("<script", i + 1);
        }
        return sb.toString();
    }
}

