/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OptionsCookieHelper {
    private static final String COOKIE_VALUE_SIGN = "=";
    private static final String COOKIE_VALUE_SEP = "&";
    private static final String COOKIE_NAME = "JIRAEmailThisIssue";
    private static final String COOKIE_CMT = "Stores last specified user options for JIRA plugin Email This Issue";
    private static transient Logger logger = Logger.getLogger(OptionsCookieHelper.class);

    public void set(Map<String, String> values, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = this.getCookie(this.getCookieName(), this.getCookieValue(values), this.getCookieComment(), request);
        cookie.setMaxAge(this.getMaxAge());
        response.addCookie(cookie);
    }

    public void delete(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = this.getCookie(this.getCookieName(), "", "", request);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public Map<String, String> get(HttpServletRequest request) {
        Map<String, String> cookieValue = null;
        Cookie[] cookies = request.getCookies();
        for (int i = 0; cookies != null && cookieValue == null && i < cookies.length; ++i) {
            if (!this.getCookieName().equals(cookies[i].getName())) continue;
            cookieValue = this.getCookieValue(cookies[i]);
        }
        return cookieValue;
    }

    protected String getCookieValue(Map<String, String> values) {
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            Iterator<Map.Entry<String, String>> it = values.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> value = it.next();
                sb.append(value.getKey()).append(COOKIE_VALUE_SIGN).append(value.getValue() == null ? "" : value.getValue());
                if (!it.hasNext()) continue;
                sb.append(COOKIE_VALUE_SEP);
            }
        }
        String cookieValue = sb.toString();
        try {
            cookieValue = URLEncoder.encode(cookieValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return cookieValue;
    }

    protected Map<String, String> getCookieValue(Cookie cookie) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (cookie != null && StringUtils.isNotEmpty((String)cookie.getValue())) {
            String cookieValue = cookie.getValue();
            try {
                cookieValue = URLDecoder.decode(cookieValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return values;
            }
            String[] tokens = cookieValue.split(COOKIE_VALUE_SEP);
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].indexOf(COOKIE_VALUE_SIGN) > 0) {
                    try {
                        String key = tokens[i].substring(0, tokens[i].indexOf(COOKIE_VALUE_SIGN));
                        String value = URLDecoder.decode(tokens[i].substring(tokens[i].indexOf(COOKIE_VALUE_SIGN) + 1), "UTF-8");
                        values.put(key, value);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                logger.warn((Object)("Cookie value is not correctly formatted: " + cookie.getValue()));
            }
        }
        return values;
    }

    protected Cookie getCookie(String name, String value, String comment, HttpServletRequest request) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(request.getContextPath() + "/secure/com.metainf.jira.plugin.emailissue.action.EmailThisIssue!view.jspa");
        cookie.setComment(comment);
        cookie.setSecure(false);
        cookie.setVersion(0);
        return cookie;
    }

    public String getCookieName() {
        return COOKIE_NAME;
    }

    public String getCookieComment() {
        return COOKIE_CMT;
    }

    public int getMaxAge() {
        return Integer.MAX_VALUE;
    }
}

