/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class MD5Util {
    public static String md5Hex(File file) throws Exception {
        return MD5Util.getMD5Checksum(MD5Util.createChecksum(file));
    }

    public static String md5Hex(String original) {
        try {
            return original == null ? null : MD5Util.getMD5Checksum(original.getBytes());
        }
        catch (Exception e) {
            return original;
        }
    }

    private static byte[] createChecksum(File file) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    private static String getMD5Checksum(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            File file = new File(args[0]);
            System.out.println("File: " + file);
            System.out.println("MD5 Hex Checksum: ");
            System.out.println(MD5Util.md5Hex(file));
        }
    }
}

