/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public class FileUtils {
    public static String readText(InputStream templateStream) {
        BufferedReader reader = null;
        try {
            int len;
            reader = new BufferedReader(new InputStreamReader(templateStream, "UTF-8"));
            StringWriter stringWriter = new StringWriter();
            char[] buf = new char[1024];
            while ((len = reader.read(buf, 0, 1024)) != -1) {
                stringWriter.write(buf, 0, len);
            }
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read template: " + e, e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String readFile(String resourceName) {
        InputStream is = FileUtils.resolveFile(resourceName);
        return FileUtils.readText(is);
    }

    public static InputStream resolveFile(String resourceName) throws RuntimeException {
        InputStream resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, MailTemplateManager.class);
        if (resource == null) {
            throw new RuntimeException("Template not found:" + resourceName);
        }
        return resource;
    }
}

