/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import com.atlassian.plugin.util.Assertions;
import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public class Downloader<T> {
    private String url;
    private int timeout;

    public Downloader(String url, int timeout) {
        this(url);
        this.timeout = timeout;
    }

    public Downloader(String url) {
        this.url = (String)Assertions.notNull((String)"url", (Object)url);
    }

    public T download(ResponseHandler<T> callback) throws IOException {
        String contentType;
        if (callback == null) {
            throw new RuntimeException("Callback is null");
        }
        HttpClient client = new HttpClient();
        HttpClientParams params = client.getParams();
        if (this.timeout > 0) {
            params.setConnectionManagerTimeout((long)this.timeout);
            params.setSoTimeout(this.timeout);
        }
        URI uri = new URI(this.url, false);
        GetMethod getMethod = new GetMethod();
        getMethod.setURI(uri);
        client.executeMethod((HttpMethod)getMethod);
        Header contentTypeHeader = getMethod.getResponseHeader("Content-Type");
        String string = contentType = contentTypeHeader == null ? null : contentTypeHeader.getValue();
        if (contentType != null && contentType.contains(";")) {
            contentType = contentType.split(";")[0].trim();
        }
        Response response = new Response(getMethod.getStatusCode(), contentType, getMethod.getResponseContentLength(), (HttpMethod)getMethod);
        return callback.onResponse(response);
    }

    public static class Response {
        private int statusCode;
        private String contentType;
        private long responseLength;
        private HttpMethod http;

        public Response(int statusCode, String contentType, long responseLength, HttpMethod http) {
            this.statusCode = statusCode;
            this.contentType = contentType;
            this.responseLength = responseLength;
            this.http = http;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getContentType() {
            return this.contentType;
        }

        public long getResponseLength() {
            return this.responseLength;
        }

        public HttpMethod getHttp() {
            return this.http;
        }

        public boolean isOk() {
            return this.getStatusCode() == 200;
        }
    }

    public static interface ResponseHandler<T> {
        public T onResponse(Response var1) throws IOException;
    }
}

