/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.CalculatedCFType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.metainf.jira.plugin.emailissue.action.GlobalConfigHelper;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CustomFieldUtil {
    public static final Pattern CUSTOMFIELD_KEY = Pattern.compile("customfield_[0-9]{5,10}");

    public static CustomField firstFieldByType(Collection<CustomField> fields, Class fieldType) {
        Collection<CustomField> filtered = CustomFieldUtil.filterByType(fields, fieldType);
        return filtered == null || filtered.isEmpty() ? null : filtered.iterator().next();
    }

    public static Collection<CustomField> filterByType(Collection<CustomField> fields, Class fieldType) {
        ArrayList<CustomField> filtered = new ArrayList<CustomField>(fields);
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            CustomField customField = (CustomField)it.next();
            CustomFieldType customFieldType = customField.getCustomFieldType();
            if (fieldType.isAssignableFrom(customFieldType.getClass())) continue;
            it.remove();
        }
        return filtered;
    }

    public static Collection<CustomField> filterByType(Collection<CustomField> fields, String fieldTypeName) {
        ArrayList<CustomField> filtered = new ArrayList<CustomField>(fields);
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            CustomField customField = (CustomField)it.next();
            CustomFieldType customFieldType = customField.getCustomFieldType();
            if (customFieldType.getClass().getName().equalsIgnoreCase(fieldTypeName)) continue;
            it.remove();
        }
        return filtered;
    }

    public static List<CustomField> filterFields(Configuration globalConfiguration, Collection<CustomField> fields) {
        ArrayList<CustomField> filtered = new ArrayList<CustomField>(fields);
        GlobalConfigHelper.excludeFields(globalConfiguration, filtered);
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            CustomField customField = (CustomField)it.next();
            CustomFieldType fieldType = customField.getCustomFieldType();
            if (fieldType instanceof UserCFType || fieldType instanceof MultiUserCFType || fieldType instanceof MultiGroupCFType || fieldType instanceof RenderableTextCFType || fieldType instanceof SelectCFType || fieldType instanceof MultiSelectCFType || fieldType instanceof CalculatedCFType || CustomFieldUtil.isBugWatcherField(fieldType) || CustomFieldUtil.isJIRAToolkitUserPropertyField(fieldType) || CustomFieldUtil.isServiceDeskParticipantField(fieldType) || CustomFieldUtil.isCRMField(fieldType)) continue;
            it.remove();
        }
        return filtered;
    }

    public static List<CustomField> filterFields(Configuration globalConfiguration, Collection<CustomField> fields, Issue issue) {
        ArrayList<CustomField> filtered = new ArrayList<CustomField>(fields);
        GlobalConfigHelper.excludeFields(globalConfiguration, filtered);
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            CustomField customField = (CustomField)it.next();
            CustomFieldType fieldType = customField.getCustomFieldType();
            if (!(fieldType instanceof UserCFType || fieldType instanceof MultiUserCFType || fieldType instanceof MultiGroupCFType || fieldType instanceof RenderableTextCFType || fieldType instanceof SelectCFType || fieldType instanceof MultiSelectCFType || CustomFieldUtil.isBugWatcherField(fieldType) || CustomFieldUtil.isJIRAToolkitUserPropertyField(fieldType))) {
                it.remove();
                continue;
            }
            Object value = issue.getCustomFieldValue(customField);
            if (value != null && (!(value instanceof Collection) || !((Collection)value).isEmpty()) && (!CustomFieldUtil.isBugWatcherField(fieldType) || !(value instanceof Map) || !((Map)value).isEmpty())) continue;
            it.remove();
        }
        return filtered;
    }

    public static List<CustomField> filterForSettableFields(Collection<CustomField> fields) {
        ArrayList<CustomField> filtered = new ArrayList<CustomField>(fields);
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            CustomField customField = (CustomField)it.next();
            CustomFieldType fieldType = customField.getCustomFieldType();
            if (fieldType instanceof UserCFType || fieldType instanceof MultiUserCFType || fieldType instanceof MultiGroupCFType || fieldType instanceof RenderableTextCFType || fieldType instanceof SelectCFType || fieldType instanceof CascadingSelectCFType || fieldType instanceof MultiSelectCFType || fieldType instanceof NumberCFType || fieldType instanceof DateCFType || fieldType instanceof DateTimeCFType || fieldType instanceof LabelsCFType || CustomFieldUtil.isEpicLinkField(fieldType) || CustomFieldUtil.isServiceDeskRequestTypeField(fieldType)) continue;
            it.remove();
        }
        return filtered;
    }

    public static boolean isServiceDeskRequestTypeField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.servicedesk.internal.customfields.origin.VpOriginCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isEpicLinkField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isBugWatcherField(CustomFieldType fieldType) {
        return fieldType != null && "com.metainf.jira.plugin.watch.field.IssueWatchersField".equals(fieldType.getClass().getName());
    }

    public static boolean isJIRAToolkitUserPropertyField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.jira.toolkit.customfield.UserPropertyCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isServiceDeskParticipantField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isServiceDeskSLAField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.servicedesk.internal.sla.customfield.SLACFType".equals(fieldType.getClass().getName());
    }

    public static boolean isJIRASoftwareSprintField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.greenhopper.customfield.sprint.SprintCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isJIRASoftwareEpicNameField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.greenhopper.customfield.epiclabel.EpicLabelCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isJIRASoftwareEpicStatusField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.greenhopper.customfield.epicstatus.EpicStatusCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isJIRASoftwareEpicColorField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.greenhopper.customfield.epiccolor.EpicColorCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isJIRASoftwareRankField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.greenhopper.customfield.lexorank.LexoRankCFType".equals(fieldType.getClass().getName());
    }

    public static boolean isServiceDeskSatisfactionField(CustomFieldType fieldType) {
        return fieldType != null && "com.atlassian.servicedesk.internal.customfields.feedback.RequestFeedbackCFType".equals(fieldType.getClass().getName());
    }

    public static CustomField getServiceDeskRequestParticipantsField(Collection<CustomField> fields) {
        Collection<CustomField> requestTypesField = CustomFieldUtil.filterByType(fields, "com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCFType");
        return requestTypesField != null && !requestTypesField.isEmpty() ? requestTypesField.iterator().next() : null;
    }

    public static CustomField getServiceDeskCustomerRequestTypeField(Collection<CustomField> fields) {
        Collection<CustomField> requestTypesField = CustomFieldUtil.filterByType(fields, "com.atlassian.servicedesk.internal.customfields.origin.VpOriginCFType");
        return requestTypesField != null && !requestTypesField.isEmpty() ? requestTypesField.iterator().next() : null;
    }

    public static boolean isCRMField(CustomFieldType fieldType) {
        return fieldType != null && ("ru.teamlead.jira.plugins.crm.customfield.contact.ContactCustomField".equals(fieldType.getClass().getName()) || "ru.teamlead.jira.plugins.crm.customfield.contact.ContactsCustomField".equals(fieldType.getClass().getName()) || "ru.teamlead.jira.plugins.crm.customfield.CrmPropertyCF".equals(fieldType.getClass().getName()));
    }
}

