/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public class CollectionUtils {
    public static <T> String toString(Collection<T> items) {
        if (items == null) {
            return null;
        }
        StringBuilder list = new StringBuilder();
        for (T value : items) {
            if (value == null || StringUtils.isEmpty((String)value.toString())) continue;
            if (list.length() > 0) {
                list.append(",");
            }
            list.append(value.toString());
        }
        return list.toString();
    }

    public static void removeAllIgnoreCase(Collection<String> values, Collection<String> valuesToRemove) {
        if (values == null || values.isEmpty() || valuesToRemove == null || valuesToRemove.isEmpty()) {
            return;
        }
        values.removeAll(valuesToRemove);
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            if (!CollectionUtils.containsIgnoreCase(valuesToRemove, it.next())) continue;
            it.remove();
        }
    }

    public static boolean containsIgnoreCase(Collection<String> values, String value) {
        if (values == null || values.isEmpty() || StringUtils.isBlank((String)value)) {
            return false;
        }
        boolean contains = values.contains(value);
        Iterator<String> it = values.iterator();
        while (it.hasNext() && !contains) {
            contains = it.next().equalsIgnoreCase(value);
        }
        return contains;
    }
}

