/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Key;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.FileUtils;
import de.schlichtherle.util.ObfuscatedString;
import java.io.InputStream;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class AuthorizerImpl
implements Authorizer {
    private static String authorization = new ObfuscatedString(new long[]{787792087105692782L, -2311767152555568942L, 5421762761476161241L, 6870180467328088988L, 7111045965982973652L}).toString();
    private String authorizationPolicy;
    private static transient Logger logger = Logger.getLogger((String)Authorizer.class.getName());
    private ActiveObjects ao;
    private JiraLicenseManager jiraLicenseManager;
    private final ApplicationProperties applicationProperties;
    private final ConfigurationManager configurationManager;
    private final PluginLicenseManager pluginLicenseManager;

    public AuthorizerImpl(PluginLicenseManager pluginLicenseManager, JiraLicenseManager jiraLicenseManager, ActiveObjects ao, ApplicationProperties applicationProperties, ConfigurationManager configurationManager) {
        this.jiraLicenseManager = jiraLicenseManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.ao = ao;
        this.applicationProperties = applicationProperties;
        this.configurationManager = configurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAuthorizationPolicyConfig() {
        Key key = this.getKey();
        if (key != null) {
            return key.getKey();
        }
        InputStream is = null;
        try {
            is = ClassLoaderUtils.getResourceAsStream((String)authorization, Authorizer.class);
            String string = FileUtils.readText(is);
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private Key getKey() {
        int n = 0;
        Key[] keyArray = (Key[])this.ao.find(Key.class);
        int n2 = keyArray.length;
        if (n < n2) {
            Key key = keyArray[n];
            return key;
        }
        return null;
    }

    @Override
    public Authorizer.Policy authorize() {
        Authorizer.Policy result = this.validateCustomAuthorization();
        if (!result.isValid()) {
            result = this.validateMktPlcLicense();
        }
        this.setLicenseConfigUrl(result);
        result.setBulkEmailDisabled(this.configurationManager.getGlobalConfiguration().getDisableBulk() == 1);
        return result;
    }

    private void setLicenseConfigUrl(Authorizer.Policy policy) {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        String url = baseUrl + "/plugins/servlet/upm#manage/" + this.pluginLicenseManager.getPluginKey();
        policy.setLicenseConfigUrl(url);
    }

    private Authorizer.Policy validateMktPlcLicense() {
        Authorizer.Policy mktPlc = new Authorizer.Policy();
        mktPlc.setValid(true);
        try {
            Option license = this.pluginLicenseManager.getLicense();
            if (license.isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)license.get();
                if (pluginLicense.getError().isDefined()) {
                    mktPlc.setPolicyError(((LicenseError)pluginLicense.getError().get()).name());
                    mktPlc.setValid(false);
                } else {
                    mktPlc.setDate(pluginLicense.getExpiryDate().isDefined() ? ((DateTime)pluginLicense.getExpiryDate().get()).toDate() : null);
                    mktPlc.setNum("0");
                    mktPlc.setSid(pluginLicense.getServerId());
                    mktPlc.setType(pluginLicense.getLicenseType().toString());
                    mktPlc.setName(pluginLicense.getOrganization() != null ? pluginLicense.getOrganization().getName() : "");
                    mktPlc.setValid(true);
                }
            } else {
                mktPlc = Authorizer.Policy.invalid();
            }
        }
        catch (Exception e) {
            mktPlc = Authorizer.Policy.invalid();
        }
        mktPlc.setMktPlc(true);
        mktPlc.setUPMLicenseAware(true);
        return mktPlc;
    }

    private Authorizer.Policy validateCustomAuthorization() {
        this.authorizationPolicy = this.getAuthorizationPolicyConfig();
        if (StringUtils.isEmpty((String)this.authorizationPolicy)) {
            return Authorizer.Policy.invalid();
        }
        try {
            Authorizer.Policy p = new Authorizer.Policy(this.authorizationPolicy);
            p.setDone(p.getDate() != null && System.currentTimeMillis() > p.getDate().getTime());
            p.setFew(true);
            p.setValid(!p.isDone());
            return p;
        }
        catch (Exception e) {
            return Authorizer.Policy.invalid();
        }
    }

    @Override
    public void save(final String licenseKey) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Key>(){

            public Key doInTransaction() {
                Key key = AuthorizerImpl.this.getKey();
                if (key != null && (licenseKey == null || "".equals(licenseKey))) {
                    AuthorizerImpl.this.ao.delete(new RawEntity[]{key});
                    return key;
                }
                if (key == null) {
                    key = (Key)AuthorizerImpl.this.ao.create(Key.class, new DBParam[0]);
                }
                key.setKey(licenseKey);
                key.save();
                return key;
            }
        });
    }
}

