/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.util;

import com.metainf.jira.plugin.emailissue.util.StringUtil;
import de.schlichtherle.util.ObfuscatedString;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public interface Authorizer {
    public void save(String var1);

    public Policy authorize();

    public static final class Policy {
        private static final String DEFAULT_CHARSET = "UTF-8";
        private static final String KEY = new ObfuscatedString(new long[]{2753349388374190549L, -6855400963912442063L, -6623904916245711884L, 2465028433491674298L, 1471136610406592989L, -1451984504609086333L, -6901778378136206079L, -7269488897354159117L, 3668518249849483143L, 7320117182298478522L, -7920475578115053427L, 1956700256902136170L, 3818246344039036257L, 379983829170785143L, -976616653423390207L, 6907925243028608406L, 6459976187142088015L, -7742561790115213451L, 914143749956276524L, 709561760537222444L, -3799666335095778977L, 1501558419201576352L, 1840807633821992299L, 4299103264404817753L, 7959205684350033823L}).toString();
        String type;
        String exp;
        Date date;
        String sid;
        String num;
        String name;
        boolean done;
        boolean few;
        boolean valid;
        boolean mktPlc;
        boolean upmLicenseAware;
        boolean bulkEmailDisabled;
        private String policyError;
        private String licenseConfigUrl;

        protected Policy() {
        }

        public Policy(String policy) throws Exception {
            if (StringUtils.isNotEmpty((String)policy)) {
                byte[] licenceKeyByteArray = policy.getBytes(DEFAULT_CHARSET);
                byte[] decodedMessage = Base64.decodeBase64((byte[])licenceKeyByteArray);
                byte[] byteArray = StringUtil.xorMessage(decodedMessage, KEY.getBytes(DEFAULT_CHARSET));
                this.type = new String(Arrays.copyOfRange(byteArray, 0, 50), DEFAULT_CHARSET).trim();
                this.num = new String(Arrays.copyOfRange(byteArray, 50, 100), DEFAULT_CHARSET).trim();
                this.exp = new String(Arrays.copyOfRange(byteArray, 100, 150), DEFAULT_CHARSET).trim();
                this.name = new String(Arrays.copyOfRange(byteArray, 150, 200), DEFAULT_CHARSET).trim();
                this.sid = new String(Arrays.copyOfRange(byteArray, 200, byteArray.length), DEFAULT_CHARSET).trim();
                this.date = new SimpleDateFormat("yyyy.MM.dd").parse(this.exp);
            }
        }

        public boolean isBulkEmailDisabled() {
            return this.bulkEmailDisabled;
        }

        public void setBulkEmailDisabled(boolean bulkEmailDisabled) {
            this.bulkEmailDisabled = bulkEmailDisabled;
        }

        public String getPolicyError() {
            return this.policyError;
        }

        public void setPolicyError(String policyError) {
            this.policyError = policyError;
        }

        public boolean isUPMLicenseAware() {
            return this.upmLicenseAware;
        }

        public void setUPMLicenseAware(boolean UPMLicenseAware) {
            this.upmLicenseAware = UPMLicenseAware;
        }

        public static Policy invalid() {
            return new Policy();
        }

        public boolean isMktPlc() {
            return this.mktPlc;
        }

        public void setMktPlc(boolean mktPlc) {
            this.mktPlc = mktPlc;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        public boolean isFew() {
            return this.few;
        }

        public void setFew(boolean few) {
            this.few = few;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public String getType() {
            return this.type;
        }

        public String getExp() {
            return this.exp;
        }

        public Date getDate() {
            return this.date;
        }

        public String getSid() {
            return this.sid;
        }

        public String getNum() {
            return this.num;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setExp(String exp) {
            this.exp = exp;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setSid(String sid) {
            this.sid = sid;
        }

        public void setNum(String num) {
            this.num = num;
        }

        public int getNumInt() {
            if ("unlimited".equalsIgnoreCase(this.num)) {
                return -1;
            }
            try {
                return Integer.parseInt(this.num);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        boolean isHosted() {
            return "hosted".equalsIgnoreCase(this.type);
        }

        boolean isEvaluation() {
            return "evaluation".equalsIgnoreCase(this.type);
        }

        boolean isDeveloper() {
            return "developer".equalsIgnoreCase(this.type);
        }

        boolean isCommunity() {
            return "community".equalsIgnoreCase(this.type);
        }

        boolean isCommercial() {
            return "commercial".equalsIgnoreCase(this.type);
        }

        boolean isAcademic() {
            return "academic".equalsIgnoreCase(this.type);
        }

        public void setLicenseConfigUrl(String url) {
            this.licenseConfigUrl = url;
        }

        public String getLicenseConfigUrl() {
            return this.licenseConfigUrl;
        }
    }
}

