/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;

public class WorklogContext {
    private final IssueEvent issueEvent;
    private final JiraDurationUtils jiraDurationUtils;

    public WorklogContext(IssueEvent issueEvent, JiraDurationUtils jiraDurationUtils) {
        this.issueEvent = issueEvent;
        this.jiraDurationUtils = jiraDurationUtils;
    }

    public String getCommentTimeLogged(I18nHelper i18n) {
        Worklog worklog = this.issueEvent.getWorklog();
        return this.getTimeLogged(worklog, i18n);
    }

    public String getTimeLogged(Worklog worklog, I18nHelper i18n) {
        if (worklog != null && worklog.getTimeSpent() != null) {
            return this.jiraDurationUtils.getFormattedDuration(worklog.getTimeSpent(), i18n.getLocale());
        }
        return null;
    }
}

