/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import java.net.URI;
import java.util.Collection;

public class UserInfo {
    private ApplicationUser user;
    private Collection<ProjectRole> roles;
    private Collection<Group> groups;
    private String avatar32;

    public UserInfo(ApplicationUser user, Project project) {
        if (user != null && project != null) {
            ProjectRoleManager prm = (ProjectRoleManager)ComponentAccessor.getComponentOfType(ProjectRoleManager.class);
            this.roles = prm.getProjectRoles(user, project);
            this.groups = ComponentAccessor.getGroupManager().getGroupsForUser(user);
            URI avatar = ComponentAccessor.getAvatarService().getAvatarUrlNoPermCheck(user, Avatar.Size.SMALL);
            this.avatar32 = avatar == null ? null : avatar.toString();
        }
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public Collection<ProjectRole> getRoles() {
        return this.roles;
    }

    public Collection<Group> getGroups() {
        return this.groups;
    }

    public String getAvatar32() {
        return this.avatar32;
    }
}

