/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.mail.DiffUtils;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.TemplateIssueFactory;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.action.util.DiffViewRenderer;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.plugin.webresource.UrlMode;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.template.ImageSafeTemplateIssue;
import com.metainf.jira.plugin.emailissue.util.AnonymousUser;
import com.metainf.jira.plugin.emailissue.util.FileUtils;
import com.opensymphony.util.TextUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

public class TemplateUtils {
    public static Template getTemplate(EmailDefinition emailDefinition, ContextDao contextDao) {
        Template template = emailDefinition.getEmailTemplate();
        if (template == null) {
            Context matchingContext = TemplateUtils.resolveContext(emailDefinition.getIssueObject(), contextDao);
            template = matchingContext == null ? null : matchingContext.getTemplate();
        }
        return template;
    }

    public static Map getIssueMailContextParams(Issue issue, ApplicationUser user, EmailDefinition emailDefinition) throws GenericEntityException {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        TemplateIssueFactory tif = (TemplateIssueFactory)ComponentAccessor.getComponentOfType(TemplateIssueFactory.class);
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        templateParams.put("baseurl", baseUrl);
        templateParams.put("stringUtils", new StringUtils());
        templateParams.put("timeSpentFieldId", "timespent");
        templateParams.put("padSize", new Integer(20));
        ImageSafeTemplateIssue ti = new ImageSafeTemplateIssue(issue, baseUrl, ComponentAccessor.getFieldLayoutManager(), ComponentAccessor.getRendererManager(), ComponentAccessor.getCustomFieldManager(), (JiraDurationUtils)ComponentAccessor.getComponentOfType(JiraDurationUtils.class), (AggregateTimeTrackingCalculatorFactory)ComponentAccessor.getComponentOfType(AggregateTimeTrackingCalculatorFactory.class));
        templateParams.put("issue", (Object)ti);
        templateParams.put("remoteUser", user);
        templateParams.put("textutils", new TextUtils());
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)ComponentAccessor.getApplicationProperties());
        templateParams.put("lfbean", lookAndFeelBean);
        templateParams.put("menuTxtColour", lookAndFeelBean.getMenuTxtColour());
        templateParams.put("topHighlightColour", lookAndFeelBean.getTopHighlightColor());
        templateParams.put("menuTextHighlightColour", lookAndFeelBean.getTopTextHighlightColor());
        templateParams.put("textHighlightColour", lookAndFeelBean.getTextHeadingColour());
        templateParams.put("menuBackgroundColour", lookAndFeelBean.getMenuBackgroundColour());
        try {
            String jiraLogo = lookAndFeelBean.getLogoUrl();
            if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
                jiraLogo = ComponentAccessor.getWebResourceUrlProvider().getStaticResourcePrefix(UrlMode.ABSOLUTE) + jiraLogo;
            }
            templateParams.put("jiraLogoUrl", jiraLogo);
        }
        catch (Error jiraLogo) {
            // empty catch block
        }
        I18nBean i18nBean = new I18nBean(user);
        templateParams.put("i18n", i18nBean);
        OutlookDate formatter = new OutlookDate(i18nBean.getLocale());
        templateParams.put("dateformatter", formatter);
        ArrayList publicComments = new ArrayList(ComponentAccessor.getCommentManager().getComments(issue));
        Iterator it = publicComments.iterator();
        while (it.hasNext()) {
            Comment co = (Comment)it.next();
            if (co.getGroupLevel() == null && co.getRoleLevel() == null) continue;
            it.remove();
        }
        templateParams.put("publicComments", publicComments);
        templateParams.put("rendererManager", ComponentAccessor.getComponentOfType(RendererManager.class));
        templateParams.put("customfieldManager", ComponentAccessor.getCustomFieldManager());
        templateParams.put("userPropertyManager", ComponentAccessor.getUserPropertyManager());
        templateParams.put("emailDef", emailDefinition);
        if (emailDefinition.getIssueEvent() != null) {
            DiffViewRenderer diffViewRenderer;
            if (emailDefinition.getIssueEvent().getChangeLog() != null) {
                templateParams.put("changelog", emailDefinition.getIssueEvent().getChangeLog());
                AnonymousUser changeLogAuthor = emailDefinition.getIssueEvent().getChangeLog().getString("author") != null ? UserUtils.getUser((String)emailDefinition.getIssueEvent().getChangeLog().getString("author")) : new AnonymousUser();
                templateParams.put("changelogauthor", changeLogAuthor);
            }
            if ((diffViewRenderer = (DiffViewRenderer)ComponentAccessor.getComponent(DiffViewRenderer.class)) != null) {
                templateParams.put("diffutils", new DiffUtils(diffViewRenderer));
            }
            templateParams.put("attachments", issue.getAttachments());
            if (emailDefinition.getIssueEvent().getComment() != null) {
                templateParams.put("comment", emailDefinition.getIssueEvent().getComment());
                AnonymousUser updateAuthor = emailDefinition.getIssueEvent().getComment().getUpdateAuthorApplicationUser() == null ? new AnonymousUser() : emailDefinition.getIssueEvent().getComment().getUpdateAuthorApplicationUser();
                templateParams.put("commentauthor", updateAuthor);
                if (emailDefinition.getIssueEvent().getComment().getGroupLevel() == null) {
                    ProjectRole role = emailDefinition.getIssueEvent().getComment().getRoleLevel();
                    if (role != null) {
                        templateParams.put("roleVisibilityLevel", role.getName());
                    }
                } else {
                    templateParams.put("groupVisibilityLevel", emailDefinition.getIssueEvent().getComment().getGroupLevel());
                }
            }
        }
        return JiraMailQueueUtils.getContextParamsBody(templateParams);
    }

    public static Context resolveContext(Issue issue, ContextDao contextDao) {
        Context[] contexts = (Context[])contextDao.filter("PROJECT_ID = ? AND ISSUE_TYPES = ?", new Object[]{issue.getProjectObject().getId(), issue.getIssueType().getId()});
        if (!(contexts != null && contexts.length != 0 || (contexts = (Context[])contextDao.filter("ISSUE_TYPES = ?", new Object[]{issue.getIssueType().getId()})) != null && contexts.length != 0 || (contexts = (Context[])contextDao.filter("PROJECT_ID = ?", new Object[]{issue.getProjectObject().getId()})) != null && contexts.length != 0)) {
            contexts = (Context[])contextDao.filter("PROJECT_ID IS NULL AND ISSUE_TYPES IS NULL", new Object[0]);
        }
        return contexts == null || contexts.length == 0 ? null : contexts[0];
    }

    public static String getEmailTemplateContent(Issue issue, String format) {
        InputStream is = null;
        try {
            is = TemplateUtils.resolveTemplate(issue, "templates/email/" + format + "/email-this-issue");
        }
        catch (RuntimeException e) {
            is = TemplateUtils.resolveTemplate(issue, "templates/emailissue/email/" + format + "/email-this-issue");
        }
        return TemplateUtils.getTemplateContent(is);
    }

    public static String getCommentTemplateContent(Issue issue, String format) {
        return TemplateUtils.getTemplateContent(TemplateUtils.resolveTemplate(issue, "templates/emailissue/comment/" + ("html".equals(format) ? "wiki" : format) + "/email-this-issue-comment"));
    }

    public static String getSubjectTemplate() {
        return "($!issue.key) $!issue.summary $!mailSubject";
    }

    private static String getTemplateContent(InputStream templateStream) {
        return FileUtils.readText(templateStream);
    }

    private static InputStream resolveTemplate(Issue issue, String baseResourceName) throws RuntimeException {
        if (issue == null) {
            String resourceName = baseResourceName + ".vm";
            InputStream resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, TemplateUtils.class);
            if (resource == null) {
                throw new RuntimeException("Template not found for issue:" + issue.getKey());
            }
            return resource;
        }
        String resourceName = baseResourceName + "." + issue.getProjectObject().getKey() + "." + issue.getIssueType().getId() + ".vm";
        InputStream resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, TemplateUtils.class);
        if (resource == null && (resource = ClassLoaderUtils.getResourceAsStream((String)(resourceName = baseResourceName + "." + issue.getIssueType().getId() + ".vm"), TemplateUtils.class)) == null && (resource = ClassLoaderUtils.getResourceAsStream((String)(resourceName = baseResourceName + "." + issue.getProjectObject().getKey() + ".vm"), TemplateUtils.class)) == null) {
            resourceName = baseResourceName + ".vm";
            resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, TemplateUtils.class);
        }
        if (resource == null) {
            throw new RuntimeException("Template not found for issue:" + issue.getKey());
        }
        return resource;
    }
}

