/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.bean.I18nBean;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.template.TemplateRenderer;
import com.metainf.jira.plugin.emailissue.template.TemplateSupport;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TemplateSupportImpl
implements TemplateSupport {
    private ServiceDeskManager serviceDeskManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final TemplateDao templateDao;
    private final TemplateRenderer templateRenderer;
    private static final ThreadLocal<Set<Integer>> templatesBeingRenderedRecursively = new ThreadLocal();

    public TemplateSupportImpl(DateTimeFormatterFactory dateTimeFormatterFactory, JsonEntityPropertyManager jsonEntityPropertyManager, FieldLayoutManager fieldLayoutManager, TemplateDao templateDao, TemplateRenderer templateRenderer) {
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.templateDao = templateDao;
        this.templateRenderer = templateRenderer;
    }

    @Override
    public String formatDate(Object fieldValue, String pattern) {
        if (fieldValue == null || !(fieldValue instanceof Date)) {
            return "";
        }
        Date date = (Date)fieldValue;
        try {
            if (StringUtils.isBlank((String)pattern)) {
                return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE).format(date);
            }
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            return date.toString();
        }
    }

    @Override
    public String formatDateTime(Object fieldValue, String pattern) {
        if (fieldValue == null || !(fieldValue instanceof Date)) {
            return "";
        }
        Date date = (Date)fieldValue;
        try {
            if (StringUtils.isBlank((String)pattern)) {
                return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.COMPLETE).format(date);
            }
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            return date.toString();
        }
    }

    @Override
    public String leftPad(String str, int size) {
        return org.apache.commons.lang3.StringUtils.leftPad((String)str, (int)size);
    }

    @Override
    public String leftPad(String str) {
        return org.apache.commons.lang3.StringUtils.leftPad((String)str, (int)20);
    }

    @Override
    public Locale getLocale(String localeName) {
        String[] localeParts;
        Locale locale = null;
        String[] stringArray = localeParts = StringUtils.isNotBlank((String)localeName) ? localeName.split("_") : null;
        if (localeParts != null) {
            locale = localeParts.length == 1 ? new Locale(localeParts[0]) : (localeParts.length == 2 ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeParts[0], localeParts[1], localeParts[2]));
        }
        return locale;
    }

    @Override
    public I18nHelper getI18nHelper(Locale locale) {
        return locale == null ? new I18nBean() : new I18nBean(locale);
    }

    @Override
    public I18nHelper getI18nHelper(String localeName) {
        return this.getI18nHelper(this.getLocale(localeName));
    }

    @Override
    public boolean isMultiValueField(CustomField customField, Object fieldValue) {
        return this.isFieldOfType(customField, AbstractMultiCFType.class) || fieldValue instanceof Collection;
    }

    @Override
    public boolean isDatePickerField(CustomField customField) {
        return this.isFieldOfType(customField, DateCFType.class);
    }

    @Override
    public boolean isDateTimePickerField(CustomField customField) {
        return this.isFieldOfType(customField, DateTimeCFType.class);
    }

    @Override
    public boolean isRenderableTextField(CustomField customField) {
        return this.isFieldOfType(customField, RenderableTextCFType.class);
    }

    @Override
    public boolean isUserPickerField(CustomField customField) {
        return this.isFieldOfType(customField, UserCFType.class);
    }

    @Override
    public boolean isMultiUserPickerField(CustomField customField) {
        return this.isFieldOfType(customField, MultiUserCFType.class);
    }

    @Override
    public boolean isMultiGroupPickerField(CustomField customField) {
        return this.isFieldOfType(customField, MultiGroupCFType.class);
    }

    @Override
    public boolean isSelectField(CustomField customField) {
        return this.isFieldOfType(customField, SelectCFType.class);
    }

    @Override
    public boolean isMultiSelectField(CustomField customField) {
        return this.isFieldOfType(customField, MultiSelectCFType.class);
    }

    @Override
    public boolean isCascadeSelectField(CustomField customField) {
        return this.isFieldOfType(customField, CascadingSelectCFType.class);
    }

    @Override
    public boolean isNumberField(CustomField customField) {
        return this.isFieldOfType(customField, NumberCFType.class);
    }

    @Override
    public boolean isLabelsField(CustomField customField) {
        return this.isFieldOfType(customField, LabelsCFType.class);
    }

    @Override
    public boolean isEpicLinkField(CustomField customField) {
        return customField != null && customField.getCustomFieldType() != null && CustomFieldUtil.isEpicLinkField(customField.getCustomFieldType());
    }

    @Override
    public boolean isServiceDeskRequestTypeField(CustomField customField) {
        return customField != null && customField.getCustomFieldType() != null && CustomFieldUtil.isServiceDeskRequestTypeField(customField.getCustomFieldType());
    }

    @Override
    public boolean isServiceDeskRequestParticipantField(CustomField customField) {
        return customField != null && customField.getCustomFieldType() != null && CustomFieldUtil.isServiceDeskParticipantField(customField.getCustomFieldType());
    }

    public boolean isFieldOfType(CustomField customField, Class type) {
        return type != null && customField != null && customField.getCustomFieldType() != null && type.isAssignableFrom(customField.getCustomFieldType().getClass());
    }

    @Override
    public boolean isEpicNameField(CustomField customField) {
        return CustomFieldUtil.isJIRASoftwareEpicNameField(customField.getCustomFieldType());
    }

    @Override
    public boolean isEpicStatusField(CustomField customField) {
        return CustomFieldUtil.isJIRASoftwareEpicStatusField(customField.getCustomFieldType());
    }

    @Override
    public boolean isEpicColorField(CustomField customField) {
        return CustomFieldUtil.isJIRASoftwareEpicColorField(customField.getCustomFieldType());
    }

    @Override
    public boolean isRankField(CustomField customField) {
        return CustomFieldUtil.isJIRASoftwareRankField(customField.getCustomFieldType());
    }

    @Override
    public boolean isSprintField(CustomField customField) {
        return CustomFieldUtil.isJIRASoftwareSprintField(customField.getCustomFieldType());
    }

    @Override
    public boolean isServiceDeskSLAField(CustomField customField) {
        return CustomFieldUtil.isServiceDeskSLAField(customField.getCustomFieldType());
    }

    @Override
    public boolean isServiceDeskSatisfactionField(CustomField customField) {
        return CustomFieldUtil.isServiceDeskSatisfactionField(customField.getCustomFieldType());
    }

    @Override
    public String getParentValueFromCascadingSelectFieldValue(Map cascadeSelectFieldValue) {
        if (cascadeSelectFieldValue == null) {
            return null;
        }
        Option parent = (Option)cascadeSelectFieldValue.get(null);
        return parent == null ? null : parent.getValue();
    }

    @Override
    public String getChildValueFromCascadingSelectFieldValue(Map cascadeSelectFieldValue) {
        if (cascadeSelectFieldValue == null) {
            return null;
        }
        Option child = (Option)cascadeSelectFieldValue.get("1");
        return child == null ? null : child.getValue();
    }

    @Override
    public boolean isRenderableValue(CustomField customField, Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return !"[]".equals(value.toString());
        }
        if (value instanceof String) {
            return StringUtils.isNotBlank((String)((String)value));
        }
        return true;
    }

    @Override
    public String renderRank(Issue issue, CustomField customField, Object fieldValue) {
        return this.renderCustomField(issue, customField);
    }

    @Override
    public String renderSprintName(Issue issue, CustomField customField, Object fieldValue) {
        return this.renderCustomField(issue, customField);
    }

    @Override
    public String renderRequestTypeName(Issue issue, CustomField customField, Object fieldValue) {
        return this.renderCustomField(issue, customField);
    }

    @Override
    public String renderSLA(Issue issue, CustomField customField, Object fieldValue) {
        return this.renderCustomField(issue, customField);
    }

    @Override
    public String renderSatisfaction(Issue issue, CustomField customField, Object fieldValue) {
        return this.renderCustomField(issue, customField);
    }

    @Override
    public String renderCustomField(Issue issue, CustomField customField) {
        if (customField == null || issue == null) {
            return null;
        }
        FieldLayoutItem fli = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem((OrderableField)customField);
        return customField.getViewHtml(fli, null, issue);
    }

    @Override
    public void setServiceDeskManager(ServiceDeskManager serviceDeskManager) {
        this.serviceDeskManager = serviceDeskManager;
    }

    @Override
    public JSONObject getIssueProperty(Long issueId, String propertyName) {
        EntityProperty ep = this.jsonEntityPropertyManager.get("IssueProperty", issueId, propertyName);
        if (ep != null && ep.getValue() != null) {
            try {
                JSONObject jo = new JSONObject(ep.getValue());
                return jo;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String renderTemplate(long templateId, String format, Map templateParams) {
        String renderedContent = "";
        Template template = (Template)this.templateDao.getById(templateId);
        if (template != null) {
            renderedContent = this.renderTemplate(template, format, templateParams);
        }
        return renderedContent;
    }

    @Override
    public String renderTemplate(String templateName, String format, Map templateParams) {
        String renderedContent = "";
        Template[] templates = (Template[])this.templateDao.filter("NAME = ?", new Object[]{templateName});
        if (templates != null && templates.length > 0) {
            renderedContent = this.renderTemplate(templates[0], format, templateParams);
        }
        return renderedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderTemplate(Template template, String format, Map templateParams) {
        String content = "";
        if (template != null && this.pushRenderedTemplate(template)) {
            try {
                templatesBeingRenderedRecursively.get().add(template.getID());
                TemplateRenderer.TargetFormat targetFormat = "html".equalsIgnoreCase(format) ? TemplateRenderer.TargetFormat.HTML : TemplateRenderer.TargetFormat.TEXT;
                String templateContent = targetFormat == TemplateRenderer.TargetFormat.HTML ? template.getHtml() : template.getText();
                content = this.templateRenderer.renderContent(templateContent, null, templateParams, targetFormat);
            }
            finally {
                templatesBeingRenderedRecursively.get().remove(template.getID());
            }
        }
        return content;
    }

    private boolean pushRenderedTemplate(Template template) {
        if (templatesBeingRenderedRecursively.get() == null) {
            templatesBeingRenderedRecursively.set(new HashSet());
            templatesBeingRenderedRecursively.get().add(template.getID());
            return true;
        }
        if (!templatesBeingRenderedRecursively.get().contains(template.getID())) {
            templatesBeingRenderedRecursively.get().add(template.getID());
            return true;
        }
        return false;
    }

    @Override
    public boolean isInternalComment(Comment comment) {
        return this.serviceDeskManager.isInternalComment(comment);
    }
}

