/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.velocity.VelocityManager;
import com.metainf.jira.plugin.emailissue.template.TemplateRenderer;
import com.metainf.jira.plugin.emailissue.util.FileUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TemplateRendererImpl
implements TemplateRenderer {
    private final VelocityManager velocityManager;
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final Object lock = new Object();
    private String textMacro;
    private String htmlMacro;

    public TemplateRendererImpl(VelocityManager velocityManager) {
        this.velocityManager = velocityManager;
    }

    @Override
    public String renderHtmlContent(String template, String baseurl, Map contextParams) {
        return this.renderContent(template, baseurl, contextParams, TemplateRenderer.TargetFormat.HTML);
    }

    @Override
    public String renderTextContent(String template, String baseurl, Map contextParams) {
        return this.renderContent(template, baseurl, contextParams, TemplateRenderer.TargetFormat.TEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String renderContent(String template, String baseurl, Map contextParams, TemplateRenderer.TargetFormat targetFormat) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        String macros = FileUtils.readFile("templates/themes/" + targetFormat.name().toLowerCase() + "/macros.vm");
        StringBuilder sb = new StringBuilder(macros).append("\n\n").append(template);
        String renderedContent = null;
        Object object = lock;
        synchronized (object) {
            renderedContent = this.velocityManager.getEncodedBodyForContent(sb.toString(), baseurl, contextParams);
        }
        return renderedContent != null ? renderedContent.trim() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTextMacro() {
        if (this.textMacro == null) {
            TemplateRendererImpl templateRendererImpl = this;
            synchronized (templateRendererImpl) {
                if (this.textMacro == null) {
                    this.textMacro = FileUtils.readFile("templates/themes/text/macros.vm");
                }
            }
        }
        return this.textMacro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readHtmlMacro() {
        if (this.htmlMacro == null) {
            TemplateRendererImpl templateRendererImpl = this;
            synchronized (templateRendererImpl) {
                if (this.htmlMacro == null) {
                    this.htmlMacro = FileUtils.readFile("templates/themes/html/macros.vm");
                }
            }
        }
        return this.htmlMacro;
    }
}

