/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import java.util.LinkedList;
import java.util.List;

public class TemplateField {
    private String name;
    private String template;
    public static final List<TemplateField> systemFields = new LinkedList<TemplateField>();
    public static final List<TemplateField> complexFields = new LinkedList<TemplateField>();

    public TemplateField(String name, String template) {
        this.name = name;
        this.template = template;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    static {
        systemFields.add(new TemplateField("key", "$!issue.key"));
        systemFields.add(new TemplateField("affectedVersions", "$!jetiFieldRenderer.renderVersions($!issue.affectedVersions)"));
        systemFields.add(new TemplateField("assignee", "$!jetiFieldRenderer.renderUser($!issue.assignee)"));
        systemFields.add(new TemplateField("components", "$!jetiFieldRenderer.renderComponents($!issue.components)"));
        systemFields.add(new TemplateField("created", "$!jetiFieldRenderer.renderDateTime($!issue.created)"));
        systemFields.add(new TemplateField("description", "$!issue.description"));
        systemFields.add(new TemplateField("dueDate", "$!jetiFieldRenderer.renderDateTime($!issue.dueDate)"));
        systemFields.add(new TemplateField("environment", "$!issue.environment"));
        systemFields.add(new TemplateField("fixVersions", "$!jetiFieldRenderer.renderVersions($!issue.fixVersions)"));
        systemFields.add(new TemplateField("issueType", "$!jetiFieldRenderer.renderIssueConstant($!issue.issueTypeObject)"));
        systemFields.add(new TemplateField("labels", "$!jetiFieldRenderer.renderLabels($!issue.labels)"));
        systemFields.add(new TemplateField("originalEstimate", "$!jetiFieldRenderer.renderEstimate($issue, $i18n)"));
        systemFields.add(new TemplateField("priority", "$!jetiFieldRenderer.renderIssueConstant($!issue.priorityObject)"));
        systemFields.add(new TemplateField("project", "$!issue.projectObject.name"));
        systemFields.add(new TemplateField("estimate", "$!jetiFieldRenderer.renderRemainingEstimate($!issue, $i18n)"));
        systemFields.add(new TemplateField("reporter", "$!jetiFieldRenderer.renderUser($!issue.reporter)"));
        systemFields.add(new TemplateField("resolutionDate", "$!jetiFieldRenderer.renderDateTime($!issue.resolutionDate)"));
        systemFields.add(new TemplateField("resolution", "$!jetiFieldRenderer.renderIssueConstant($!issue.resolutionObject)')"));
        systemFields.add(new TemplateField("status", "$!jetiFieldRenderer.renderIssueConstant($!issue.statusObject))"));
        systemFields.add(new TemplateField("summary", "$!issue.summary"));
        systemFields.add(new TemplateField("timeSpent", "$!jetiFieldRenderer.renderWorklog($issue, $i18n)"));
        systemFields.add(new TemplateField("updated", "$!jetiFieldRenderer.renderDateTime($!issue.updated)')"));
        systemFields.add(new TemplateField("votes", "$!issue.votes"));
        systemFields.add(new TemplateField("watches", "$!issue.watches"));
        complexFields.add(new TemplateField("comments", "Render as <b>HTML</b>: &#35;parse(\"templates/emailissue/email/html/public-comments.vm\") <br /> Render as <b>Text</b>: &#35;parse(\"templates/emailissue/email/text/public-comments.vm\") <br /> <br /> Find more details <b><a href=\"https://metainf.atlassian.net/wiki/x/WIDwAw\">here</a></b>."));
        complexFields.add(new TemplateField("emailLog", "Render as <b>HTML</b>: &#35;parse(\"templates/emailissue/email/html/audit-log.vm\") <br /> Render as <b>Text</b>: &#35;parse(\"templates/emailissue/email/text/audit-log.vm\") <br /> <br /> Find more details <b><a href=\"https://metainf.atlassian.net/wiki/x/T4DwAw\">here</a></b>."));
        complexFields.add(new TemplateField("linkCollection", "Add as <b>$action.escapeQuotes('$!issue.linkCollection')</b>. It returns an <a href='https://docs.atlassian.com/software/jira/docs/api/latest/com/atlassian/jira/issue/link/LinkCollection.html'>LinkCollection</a> object which provides methods to explore linked issues, link types, etc.<br /><br /><b>Important: </b>The LinkCollection contains the linked issues as the email sender sees them. As the sender may not be privileged to view all linked issues in JIRA, the collection may not issues hidden to the sender. <br /><br />To render as <b>HTML</b> add: &#35;parse('templates/emailissue/email/html/issue-links.vm') <br /> To render as <b>Text</b> add: &#35;parse('templates/emailissue/email/text/issue-links.vm')<br/><br />Find more details <a href='https://metainf.atlassian.net/wiki/x/UoDwAw'>here</a>."));
    }
}

