/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.mail.DiffUtils;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.TemplateIssue;
import com.atlassian.jira.mail.TemplateIssueFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.velocity.NumberTool;
import com.atlassian.jira.web.action.util.DiffViewRenderer;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.collect.Maps;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManagerImpl;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.template.EnhancedTemplateIssueFactory;
import com.metainf.jira.plugin.emailissue.template.FieldFormatters;
import com.metainf.jira.plugin.emailissue.template.FieldRenderer;
import com.metainf.jira.plugin.emailissue.template.MailAttachmentsManagerImpl;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.template.Renderer;
import com.metainf.jira.plugin.emailissue.template.TemplateRenderer;
import com.metainf.jira.plugin.emailissue.template.TemplateSupport;
import com.metainf.jira.plugin.emailissue.template.TemplateUser;
import com.metainf.jira.plugin.emailissue.template.UserInfo;
import com.metainf.jira.plugin.emailissue.template.WorklogContext;
import com.metainf.jira.plugin.emailissue.util.AnonymousUser;
import com.metainf.jira.plugin.emailissue.util.FileUtils;
import com.metainf.jira.plugin.emailissue.util.UserWithKey;
import com.metainf.jira.plugin.versionkit.AppVersionManager;
import com.metainf.jira.plugin.versionkit.AppVersionManagerImpl;
import com.opensymphony.util.TextUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class MailTemplateManagerImpl
implements MailTemplateManager {
    private final EnhancedTemplateIssueFactory enhancedTemplateIssueFactory;
    private FieldLayoutManager fieldLayoutManager;
    private RendererManager rendererManager;
    private CustomFieldManager customFieldManager;
    private JiraDurationUtils jiraDurationUtils;
    private ApplicationProperties applicationProperties;
    private WebResourceUrlProvider webResourceUrlProvider;
    private UserPropertyManager userPropertyManager;
    private DiffViewRenderer diffViewRenderer;
    private CommentManager commentManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final Locale locale;
    private final EventTypeManager eventTypeManager;
    private ContextDao contextDao;
    private final UserManager userManager;
    private final AvatarService avatarService;
    private final AvatarManager avatarManager;
    private final Map MASTER_PARAMS = new HashMap();
    private final TemplateRenderer templateRenderer;
    private FieldRenderer fieldRenderer;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final AppVersionManager appVersionManager;
    private final IssueSearcher issueSearcher;
    private final ServiceDeskManager serviceDeskManager;
    private final TemplateSupport templateSupport;
    private final Logger logger = Logger.getLogger(this.getClass());

    public MailTemplateManagerImpl(ProjectManager projectManager, OfBizDelegator ofBizDelegator, PluginAccessor pluginAccessor, ActiveObjects ao, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, CustomFieldManager customFieldManager, ApplicationProperties applicationProperties, WebResourceUrlProvider webResourceUrlProvider, TemplateIssueFactory templateIssueFactory, UserPropertyManager userPropertyManager, CommentManager commentManager, I18nHelper.BeanFactory beanFactory, EventTypeManager eventTypeManager, JiraAuthenticationContext jiraAuthenticationContext, FieldRenderer fieldRenderer, ContextDao contextDao, DateTimeFormatterFactory dateTimeFormatterFactory, EnhancedTemplateIssueFactory enhancedTemplateIssueFactory, AvatarService avatarService, AvatarManager avatarManager, UserManager userManager, TemplateRenderer templateRenderer, IssueSearcher issueSearcher, ProjectRoleManager projectRoleManager, UserService userService, TemplateSupport templateSupport) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.customFieldManager = customFieldManager;
        this.templateRenderer = templateRenderer;
        this.issueSearcher = issueSearcher;
        this.serviceDeskManager = new ServiceDeskManagerImpl(projectManager, ofBizDelegator, pluginAccessor, projectRoleManager, ao, userService);
        this.templateSupport = templateSupport;
        this.templateSupport.setServiceDeskManager(this.serviceDeskManager);
        this.jiraDurationUtils = (JiraDurationUtils)ComponentAccessor.getComponentOfType(JiraDurationUtils.class);
        this.fieldRenderer = fieldRenderer;
        this.contextDao = contextDao;
        this.applicationProperties = applicationProperties;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.userPropertyManager = userPropertyManager;
        this.diffViewRenderer = (DiffViewRenderer)ComponentAccessor.getComponent(DiffViewRenderer.class);
        this.commentManager = commentManager;
        this.beanFactory = beanFactory;
        this.locale = jiraAuthenticationContext.getLocale();
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.eventTypeManager = eventTypeManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.enhancedTemplateIssueFactory = enhancedTemplateIssueFactory;
        this.avatarManager = avatarManager;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.appVersionManager = new AppVersionManagerImpl();
        this.addTemplateConstants(this.MASTER_PARAMS);
    }

    @Override
    public Map getIssueMailContextParams(Issue issue, ApplicationUser applicationUser, EmailDefinition emailDefinition) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>(this.MASTER_PARAMS);
        templateParams.put("attachmentsManager", (Object)new MailAttachmentsManagerImpl(this.applicationProperties, this.avatarService, this.userManager, this.avatarManager, emailDefinition));
        templateParams.put("contextParams", templateParams);
        templateParams.put("currentTimestamp", new Date());
        templateParams.put("mailSubject", emailDefinition.getEmailIssueSubject() == null ? "" : emailDefinition.getEmailIssueSubject());
        TemplateIssue ti = this.enhancedTemplateIssueFactory.createTemplateIssue(issue);
        templateParams.put("issue", ti);
        TemplateUser templateUser = new TemplateUser(this.jiraAuthenticationContext.getLoggedInUser(), this.avatarService);
        templateParams.put("remoteUser", templateUser);
        templateParams.put("currentUser", templateUser);
        templateParams.put("currentUserInfo", new UserInfo(this.jiraAuthenticationContext.getLoggedInUser(), emailDefinition.getIssueObject().getProjectObject()));
        I18nBean i18nBean = applicationUser == null ? new I18nBean() : new I18nBean(applicationUser);
        templateParams.put("i18n", i18nBean);
        OutlookDate formatter = new OutlookDate(i18nBean.getLocale());
        templateParams.put("dateformatter", formatter);
        ArrayList publicComments = new ArrayList();
        try {
            publicComments.addAll(this.commentManager.getComments(issue));
            Iterator it = publicComments.iterator();
            while (it.hasNext()) {
                Comment co = (Comment)it.next();
                if (co.getGroupLevel() == null && co.getRoleLevel() == null && !this.serviceDeskManager.isInternalComment(co)) continue;
                it.remove();
            }
        }
        catch (NullPointerException it) {
            // empty catch block
        }
        templateParams.put("publicComments", publicComments);
        FieldLayoutItem fyi = this.fieldLayoutManager.getFieldLayout(emailDefinition.getIssueObject()).getFieldLayoutItem("comment");
        templateParams.put("commentRendererType", fyi != null ? fyi.getRendererType() : Renderer.WIKI.getKey());
        templateParams.put("emailDef", emailDefinition);
        if (emailDefinition.getComment() != null) {
            try {
                FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueType().getId()).getFieldLayoutItem("comment");
                String rendererType = fieldLayoutItem == null ? null : fieldLayoutItem.getRendererType();
                templateParams.put("htmlComment", this.rendererManager.getRenderedContent(rendererType, emailDefinition.getComment(), issue.getIssueRenderContext()));
            }
            catch (Exception e) {
                templateParams.put("htmlComment", JiraKeyUtils.linkBugKeys((String)emailDefinition.getComment()));
            }
            templateParams.put("comment", emailDefinition.getComment());
        }
        if (emailDefinition.getIssueEvent() != null) {
            if (emailDefinition.getIssueEvent().getChangeLog() != null) {
                templateParams.put("changelog", emailDefinition.getIssueEvent().getChangeLog());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("group", emailDefinition.getIssueEvent().getChangeLog().get("id"));
                List changeItems = null;
                try {
                    changeItems = emailDefinition.getIssueEvent().getChangeLog().internalDelegator.findByAnd("ChangeItem", params);
                }
                catch (GenericEntityException genericEntityException) {
                    // empty catch block
                }
                templateParams.put("changeItems", changeItems);
                ApplicationUser changeLogAuthor = this.findUserOrDefault(emailDefinition.getIssueEvent().getChangeLog().getString("author"), new AnonymousUser());
                templateParams.put("changelogauthor", new UserWithKey(changeLogAuthor));
            }
            templateParams.put("attachments", issue.getAttachments());
            if (emailDefinition.getIssueEvent().getComment() != null) {
                templateParams.putAll(this.getCommentParams(emailDefinition.getIssueEvent().getComment(), issue));
            }
            Map<String, Object> templateParamsForNotification = this.getTemplateParamsForNotificationEmail(emailDefinition);
            templateParams.putAll(templateParamsForNotification);
        }
        return JiraMailQueueUtils.getContextParamsBody(templateParams);
    }

    private void addTemplateConstants(Map templateParams) {
        templateParams.put("templateSupport", this.templateSupport);
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        templateParams.put("baseurl", baseUrl);
        templateParams.put("baseUrl", baseUrl);
        templateParams.put("isJIRA61OrLater", this.appVersionManager.isJira61OrLater());
        templateParams.put("datetimeformatter", this.dateTimeFormatterFactory.formatter());
        templateParams.put("jetiFieldRenderer", this.fieldRenderer);
        templateParams.put("jetiFieldFormatter", new FieldFormatters(this.dateTimeFormatterFactory));
        templateParams.put("stringUtils", new StringUtils());
        templateParams.put("timeSpentFieldId", "timespent");
        templateParams.put("padSize", new Integer(20));
        templateParams.put("textutils", new TextUtils());
        templateParams.put("rendererManager", this.rendererManager);
        templateParams.put("customfieldManager", this.customFieldManager);
        templateParams.put("userPropertyManager", this.userPropertyManager);
        templateParams.put("commentManager", this.commentManager);
        templateParams.put("number", new NumberTool());
        templateParams.put("jiraDurationUtils", this.jiraDurationUtils);
        if (this.diffViewRenderer != null) {
            templateParams.put("diffutils", new DiffUtils(this.diffViewRenderer));
        }
        LookAndFeelBean lfbean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        templateParams.put("lfbean", lfbean);
        templateParams.put("menuTxtColour", lfbean.getMenuTxtColour());
        templateParams.put("topHighlightColour", lfbean.getTopHighlightColor());
        templateParams.put("menuTextHighlightColour", lfbean.getTopTextHighlightColor());
        templateParams.put("textHighlightColour", lfbean.getTextHeadingColour());
        templateParams.put("menuBackgroundColour", lfbean.getMenuBackgroundColour());
        try {
            String jiraLogo = lfbean.getLogoUrl();
            if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
                jiraLogo = this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.ABSOLUTE) + jiraLogo;
            }
            templateParams.put("jiraLogoUrl", jiraLogo);
        }
        catch (Error error) {
            // empty catch block
        }
        templateParams.put("topBackgroundColour", lfbean.getTopBackgroundColour());
        templateParams.put("topTxtColour ", lfbean.getTopTxtColour());
        templateParams.put("topHighlightColor ", lfbean.getTopHighlightColor());
        templateParams.put("topTextHighlightColor ", lfbean.getTopTextHighlightColor());
        templateParams.put("topSeparatorBackgroundColor ", lfbean.getTopSeparatorBackgroundColor());
        templateParams.put("menuTxtColour ", lfbean.getMenuTxtColour());
        templateParams.put("menuBackgroundColour ", lfbean.getMenuBackgroundColour());
        templateParams.put("menuSeparatorColour ", lfbean.getMenuSeparatorColour());
        templateParams.put("textHeadingColour ", lfbean.getTextHeadingColour());
        templateParams.put("textLinkColour ", lfbean.getTextLinkColour());
        templateParams.put("textActiveLinkColour ", lfbean.getTextActiveLinkColour());
        templateParams.put("textFontFamily ", "Arial,FreeSans,Helvetica,sans-serif");
        templateParams.put("textSize ", "12px");
        templateParams.put("textColour ", "#000000");
        templateParams.put("textSubtleColour ", "#505050");
        templateParams.put("borderColour ", "#bbbbbb");
        templateParams.put("auiPanelBackgroundColour ", "#f0f0f0");
        templateParams.put("auiPanelBorderColour ", "#bbb");
        templateParams.put("auiInfoBackgroundColour ", "#e0f0ff");
        templateParams.put("auiInfoBorderColour ", "#9eb6d4");
        templateParams.put("auiSuccessBackgroundColour ", "#ddfade");
        templateParams.put("auiSuccessBorderColour ", "#93c49f");
        templateParams.put("auiErrorBackgroundColour ", "#ffe7e7");
        templateParams.put("auiErrorBorderColour ", "#df9898");
        templateParams.put("auiWarningBackgroundColour ", "#ffd");
        templateParams.put("auiWarningBorderColour ", "#f7df92");
        templateParams.put("linkstyle ", "color:${textLinkColour};");
        templateParams.put("commentBackground ", "#edf5ff");
    }

    @Override
    public Template getTemplate(EmailDefinition emailDefinition) {
        Template template = emailDefinition.getEmailTemplate();
        if (template == null) {
            Context matchingContext = this.resolveContext(emailDefinition.getIssueObject(), this.contextDao);
            template = matchingContext == null ? null : matchingContext.getTemplate();
        }
        return template;
    }

    @Override
    public Context resolveContext(Issue issue) {
        return this.resolveContext(issue, this.contextDao);
    }

    @Override
    public Context resolveContext(Issue issue, ContextDao contextDao) {
        Context resolvedContext = null;
        Context[] contexts = (Context[])contextDao.filter("PROJECT_ID = ? AND ISSUE_TYPES = ?", new Object[]{issue.getProjectObject().getId(), issue.getIssueType().getId()});
        resolvedContext = this.findContextMatchingIssue(issue, contexts);
        if (resolvedContext == null && (resolvedContext = this.findContextMatchingIssue(issue, contexts = (Context[])contextDao.filter("ISSUE_TYPES = ? AND PROJECT_ID IS NULL", new Object[]{issue.getIssueType().getId()}))) == null && (resolvedContext = this.findContextMatchingIssue(issue, contexts = (Context[])contextDao.filter("PROJECT_ID = ? AND ISSUE_TYPES IS NULL", new Object[]{issue.getProjectObject().getId()}))) == null) {
            contexts = (Context[])contextDao.filter("PROJECT_ID IS NULL AND ISSUE_TYPES IS NULL", new Object[0]);
            resolvedContext = this.findContextMatchingIssue(issue, contexts);
        }
        return resolvedContext;
    }

    protected Context findContextMatchingIssue(Issue issue, Context[] contexts) {
        if (contexts == null || contexts.length == 0) {
            return null;
        }
        Context matchingContext = null;
        List<Context> contextList = Arrays.asList(contexts);
        Collections.sort(contextList, new Context.EntityComparator());
        for (Context context : contextList) {
            if (!StringUtils.isBlank((String)context.getJQLFilter()) && !this.issueSearcher.issueMatchesJQL(context.getJQLFilter(), issue, true)) continue;
            matchingContext = context;
            break;
        }
        return matchingContext;
    }

    @Override
    public String getEmailTemplateContent(Issue issue, String format) {
        InputStream is = null;
        String jetiDefault = "/email-this-issue" + this.appVersionManager.getVersionNumber();
        try {
            is = MailTemplateManagerImpl.resolveTemplate(issue, "templates/email/" + format + jetiDefault);
        }
        catch (RuntimeException e) {
            is = MailTemplateManagerImpl.resolveTemplate(issue, "templates/emailissue/email/" + format + jetiDefault);
        }
        return MailTemplateManagerImpl.getTemplateContent(is);
    }

    @Override
    public String getCommentTemplateContent(Issue issue, String format) {
        return MailTemplateManagerImpl.getTemplateContent(MailTemplateManagerImpl.resolveTemplate(issue, "templates/emailissue/comment/" + ("html".equals(format) ? "wiki" : format) + "/email-this-issue-comment"));
    }

    @Override
    public String getMailAttributesTemplateContent(String format) {
        return MailTemplateManagerImpl.getTemplateContent(MailTemplateManagerImpl.resolveTemplate("templates/emailissue/email/" + format + "/maillog-email-attributes"));
    }

    @Override
    public String getTemplateContent(String templateResource) {
        return MailTemplateManagerImpl.getTemplateContent(MailTemplateManagerImpl.resolveTemplate(templateResource));
    }

    @Override
    public String getSubjectTemplate() {
        return "($!issue.key) $!issue.summary $!mailSubject";
    }

    private static String getTemplateContent(InputStream templateStream) {
        return FileUtils.readText(templateStream);
    }

    private static InputStream resolveTemplate(Issue issue, String baseResourceName) throws RuntimeException {
        if (issue == null) {
            String resourceName = baseResourceName + ".vm";
            InputStream resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, MailTemplateManager.class);
            if (resource == null) {
                throw new RuntimeException("Template not found for issue:" + issue.getKey());
            }
            return resource;
        }
        String resourceName = baseResourceName + "." + issue.getProjectObject().getKey() + "." + issue.getIssueType().getId() + ".vm";
        InputStream resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, MailTemplateManager.class);
        if (resource == null && (resource = ClassLoaderUtils.getResourceAsStream((String)(resourceName = baseResourceName + "." + issue.getIssueType().getId() + ".vm"), MailTemplateManager.class)) == null && (resource = ClassLoaderUtils.getResourceAsStream((String)(resourceName = baseResourceName + "." + issue.getProjectObject().getKey() + ".vm"), MailTemplateManager.class)) == null) {
            resourceName = baseResourceName + ".vm";
            resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, MailTemplateManager.class);
        }
        if (resource == null) {
            throw new RuntimeException("Template not found for issue:" + issue.getKey());
        }
        return resource;
    }

    private static InputStream resolveTemplate(String baseResourceName) throws RuntimeException {
        String resourceName = baseResourceName + ".vm";
        InputStream resource = ClassLoaderUtils.getResourceAsStream((String)resourceName, MailTemplateManager.class);
        if (resource == null) {
            throw new RuntimeException("Template not found:" + baseResourceName);
        }
        return resource;
    }

    private Map<String, Object> getTemplateParamsForNotificationEmail(EmailDefinition emailDefinition) {
        HashMap templateParams = Maps.newHashMap();
        templateParams.put("templateSupport", this.templateSupport);
        I18nHelper i18nHelper = this.beanFactory.getInstance(this.locale);
        templateParams.put("datetimeformatter", this.dateTimeFormatterFactory.formatter());
        templateParams.put("attachmentsManager", new MailAttachmentsManagerImpl(this.applicationProperties, this.avatarService, this.userManager, this.avatarManager, emailDefinition));
        templateParams.put("isJIRA61OrLater", this.appVersionManager.isJira61OrLater());
        templateParams.put("i18n", i18nHelper);
        OutlookDate formatter = new OutlookDate(this.locale);
        templateParams.put("dateformatter", formatter);
        LookAndFeelBean landf = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        templateParams.put("lfbean", landf);
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        templateParams.put("baseurl", baseUrl);
        templateParams.put("baseUrl", baseUrl);
        templateParams.put("currentTimestamp", new Date());
        String jiraLogo = landf.getLogoUrl();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.ABSOLUTE) + jiraLogo;
        }
        templateParams.put("jiraLogoUrl", jiraLogo);
        templateParams.put("context", this);
        TemplateIssue ti = this.enhancedTemplateIssueFactory.createTemplateIssue(emailDefinition.getIssueObject());
        templateParams.put("issue", ti);
        templateParams.put("params", emailDefinition.getIssueEvent().getParams());
        TemplateUser templateUser = new TemplateUser(this.jiraAuthenticationContext.getLoggedInUser(), this.avatarService);
        templateParams.put("remoteUser", templateUser);
        templateParams.put("currentUser", templateUser);
        templateParams.put("currentUserInfo", new UserInfo(this.jiraAuthenticationContext.getLoggedInUser(), emailDefinition.getIssueObject().getProjectObject()));
        templateParams.putAll(this.getUtilParams());
        templateParams.putAll(this.getAttachmentParams(emailDefinition.getIssueObject()));
        templateParams.putAll(this.getCommentParams(emailDefinition.getIssueEvent().getComment(), emailDefinition.getIssueObject()));
        templateParams.putAll(this.getOriginalCommentParams(emailDefinition.getIssueEvent(), emailDefinition.getIssueObject()));
        templateParams.putAll(this.getWorkLogParams(emailDefinition.getIssueEvent()));
        templateParams.putAll(this.getChangeLogParams(emailDefinition.getIssueEvent()));
        templateParams.putAll(this.getDiffParams());
        templateParams.put("security", emailDefinition.getIssueObject().getSecurityLevel());
        templateParams.put("rendererManager", this.rendererManager);
        return templateParams;
    }

    private Map<String, Object> getDiffParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("diffutils", new DiffUtils(this.diffViewRenderer));
        return params;
    }

    private Map<String, Object> getOriginalCommentParams(IssueEvent issueEvent, Issue issue) {
        HashMap<String, Object> originalCommentParams = new HashMap<String, Object>();
        Comment originalComment = (Comment)issueEvent.getParams().get("originalcomment");
        if (originalComment != null) {
            try {
                FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueType().getId()).getFieldLayoutItem("comment");
                String rendererType = fieldLayoutItem == null ? null : fieldLayoutItem.getRendererType();
                originalCommentParams.put("originalhtmlComment", this.rendererManager.getRenderedContent(rendererType, originalComment.getBody(), issue.getIssueRenderContext()));
            }
            catch (Exception e) {
                originalCommentParams.put("originalhtmlComment", JiraKeyUtils.linkBugKeys((String)originalComment.getBody()));
            }
            originalCommentParams.put("originalcomment", originalComment);
            ApplicationUser author = originalComment.getAuthorApplicationUser();
            originalCommentParams.put("originalcommentauthor", new UserWithKey(author));
            if (author == null) {
                originalCommentParams.put("originalcommentauthor", new AnonymousUser());
            }
            if (originalComment.getGroupLevel() == null) {
                ProjectRole role = originalComment.getRoleLevel();
                if (role != null) {
                    originalCommentParams.put("originalroleVisibilityLevel", role.getName());
                }
            } else {
                originalCommentParams.put("originalgroupVisibilityLevel", originalComment.getGroupLevel());
            }
        }
        return originalCommentParams;
    }

    public Map<String, Object> getUtilParams() {
        HashMap<String, Object> utilParams = new HashMap<String, Object>();
        utilParams.put("stringUtils", new StringUtils());
        utilParams.put("padSize", 20);
        utilParams.put("timeSpentFieldId", "timespent");
        return utilParams;
    }

    public Map<String, Object> getAttachmentParams(Issue issue) {
        HashMap<String, Object> attachmentParams = new HashMap<String, Object>();
        attachmentParams.put("attachments", issue.getAttachments());
        return attachmentParams;
    }

    private Map<String, Object> getCommentParams(Comment comment, Issue issue) {
        HashMap<String, Object> commentParams = new HashMap<String, Object>();
        if (comment != null) {
            try {
                FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueType().getId()).getFieldLayoutItem("comment");
                String rendererType = fieldLayoutItem == null ? null : fieldLayoutItem.getRendererType();
                commentParams.put("htmlComment", this.rendererManager.getRenderedContent(rendererType, comment.getBody(), issue.getIssueRenderContext()));
            }
            catch (Exception e) {
                commentParams.put("htmlComment", JiraKeyUtils.linkBugKeys((String)comment.getBody()));
            }
            commentParams.put("comment", comment);
            ApplicationUser updateAuthor = comment.getUpdateAuthorApplicationUser();
            commentParams.put("commentauthor", new UserWithKey(updateAuthor));
            if (updateAuthor == null) {
                commentParams.put("commentauthor", new AnonymousUser());
            }
            if (comment.getGroupLevel() == null) {
                ProjectRole role = comment.getRoleLevel();
                if (role != null) {
                    commentParams.put("roleVisibilityLevel", role.getName());
                }
            } else {
                commentParams.put("groupVisibilityLevel", comment.getGroupLevel());
            }
        }
        return commentParams;
    }

    private Map<String, Object> getWorkLogParams(IssueEvent issueEvent) {
        HashMap<String, Object> workLogParams = new HashMap<String, Object>();
        Worklog worklog = issueEvent.getWorklog();
        if (worklog != null) {
            workLogParams.put("worklog", worklog);
            workLogParams.put("context", new WorklogContext(issueEvent, this.jiraDurationUtils));
            String worklogComment = worklog.getComment();
            if (worklogComment != null) {
                String worklogCommentHtml = this.rendererManager.getRenderedContent("atlassian-wiki-renderer", worklogComment, issueEvent.getIssue().getIssueRenderContext());
                workLogParams.put("worklogCommentHtml", worklogCommentHtml);
            }
            if (worklog.getGroupLevel() == null) {
                ProjectRole role = worklog.getRoleLevel();
                if (role != null) {
                    workLogParams.put("roleVisibilityLevel", role.getName());
                }
            } else {
                workLogParams.put("groupVisibilityLevel", worklog.getGroupLevel());
            }
            Worklog originalWorklog = (Worklog)issueEvent.getParams().get("originalworklog");
            if (originalWorklog != null) {
                if (originalWorklog.getGroupLevel() == null) {
                    ProjectRole role = originalWorklog.getRoleLevel();
                    if (role != null) {
                        workLogParams.put("originalroleVisibilityLevel", role.getName());
                    }
                } else {
                    workLogParams.put("originalgroupVisibilityLevel", originalWorklog.getGroupLevel());
                }
                if (!worklog.getTimeSpent().equals(originalWorklog.getTimeSpent())) {
                    workLogParams.put("timeSpentUpdated", Boolean.TRUE);
                }
                if (!worklog.getStartDate().equals(originalWorklog.getStartDate())) {
                    workLogParams.put("startDateUpdated", Boolean.TRUE);
                }
                if (!StringUtils.equals((String)originalWorklog.getComment(), (String)worklog.getComment())) {
                    workLogParams.put("commentUpdated", Boolean.TRUE);
                }
                if (this.worklogVisibilityUpdated(originalWorklog, worklog)) {
                    workLogParams.put("visibilityUpdated", Boolean.TRUE);
                }
                workLogParams.put("originalworklog", originalWorklog);
            }
        }
        return workLogParams;
    }

    private boolean worklogVisibilityUpdated(Worklog originalWorklog, Worklog worklog) {
        String newVisibility;
        String originalVisibility = CommentVisibility.getCommentLevelFromLevels((String)originalWorklog.getGroupLevel(), (Long)originalWorklog.getRoleLevelId());
        return !StringUtils.equals((String)originalVisibility, (String)(newVisibility = CommentVisibility.getCommentLevelFromLevels((String)worklog.getGroupLevel(), (Long)worklog.getRoleLevelId())));
    }

    public String getCommentTimeLogged(I18nHelper i18n, IssueEvent issueEvent) {
        Worklog worklog = issueEvent.getWorklog();
        return this.getTimeLogged(worklog, i18n);
    }

    public String getTimeLogged(Worklog worklog, I18nHelper i18n) {
        if (worklog != null && worklog.getTimeSpent() != null) {
            return this.jiraDurationUtils.getFormattedDuration(worklog.getTimeSpent(), i18n.getLocale());
        }
        return null;
    }

    public String getEventTypeName(I18nHelper i18n, IssueEvent issueEvent) {
        try {
            EventType eventType = this.eventTypeManager.getEventType(issueEvent.getEventTypeId());
            String emailEventKey = "email." + eventType.getNameKey();
            String i18nValue = i18n.getText(emailEventKey);
            if (emailEventKey.equals(i18nValue)) {
                return eventType.getName();
            }
            return i18nValue;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Map<String, Object> getChangeLogParams(IssueEvent issueEvent) {
        HashMap<String, Object> commentParams = new HashMap<String, Object>();
        GenericValue changelog = issueEvent.getChangeLog();
        if (changelog != null) {
            commentParams.put("changelog", changelog);
            ApplicationUser changeLogAuthor = this.findUserOrDefault(changelog.getString("author"), new AnonymousUser());
            commentParams.put("changelogauthor", new UserWithKey(changeLogAuthor));
        }
        return commentParams;
    }

    private ApplicationUser findUserOrDefault(String userNameOrKey, ApplicationUser defaultUser) {
        ApplicationUser user = null;
        if (userNameOrKey != null && (user = this.userManager.getUserByName(userNameOrKey)) == null) {
            user = this.userManager.getUserByKey(userNameOrKey);
        }
        if (user == null) {
            user = defaultUser;
        }
        return user;
    }

    @Override
    public String buildEmailSubject(EmailDefinition def, Template template) throws Exception {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        Map contextParams = this.getIssueMailContextParams(def.getIssueObject(), def.getRemoteUser(), def);
        String subjectTemplate = template == null ? def.getI18n().getText("issuemail.subject") : template.getSubject();
        subjectTemplate = StringUtils.isEmpty((String)subjectTemplate) ? this.getSubjectTemplate() : subjectTemplate;
        String subject = this.templateRenderer.renderTextContent(subjectTemplate, baseUrl, contextParams);
        return subject;
    }
}

