/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import java.net.URI;
import java.net.URISyntaxException;

public class MailAttachmentsManagerImpl
extends com.atlassian.jira.mail.util.MailAttachmentsManagerImpl
implements MailAttachmentsManager {
    private final ApplicationProperties applicationProperties;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final EmailDefinition def;

    public MailAttachmentsManagerImpl(ApplicationProperties applicationProperties, AvatarService avatarService, UserManager userManager, AvatarManager avatarManager, EmailDefinition def) {
        super(avatarService, (AvatarTranscoder)ComponentAccessor.getComponentOfType(AvatarTranscoder.class), userManager, avatarManager, applicationProperties);
        this.applicationProperties = applicationProperties;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.def = def;
    }

    public String getAvatarUrl(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        URI avatarUri = this.avatarService.getAvatarUrlNoPermCheck(user, Avatar.Size.SMALL);
        return avatarUri.toString();
    }

    public String getImageUrl(String path) {
        if (this.def.getSource() == EmailSource.PREVIEW) {
            try {
                URI uri = new URI(path);
                return uri.isAbsolute() ? path : this.getAbsoluteUrl(path);
            }
            catch (URISyntaxException e) {
                return path;
            }
        }
        return super.getImageUrl(path);
    }

    public String getExternalImageUrl(String path) {
        try {
            URI uri = new URI(path);
            return uri.isAbsolute() ? path : this.getAbsoluteUrl(path);
        }
        catch (URISyntaxException e) {
            return path;
        }
    }
}

