/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarTagger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class JetiAvatarTranscoder {
    private static final String PNG_EXTENSION = ".png";
    private final AvatarTagger avatarTagger;

    public JetiAvatarTranscoder(AvatarTagger avatarTagger) {
        this.avatarTagger = avatarTagger;
    }

    public void transcodeAndTag(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.transcodeAndTag(inputStream, outputStream, Avatar.Size.MEDIUM);
    }

    private void transcodeAndTag(InputStream inputStream, OutputStream outputStream, Avatar.Size size) throws IOException {
        try {
            TranscoderInput transcoderInput = new TranscoderInput(inputStream);
            ByteArrayOutputStream transcoded = new ByteArrayOutputStream();
            TranscoderOutput transcoderOutput = new TranscoderOutput(transcoded);
            PNGTranscoder transcoder = this.newPNGTranscoder(size);
            transcoder.transcode(transcoderInput, transcoderOutput);
            this.avatarTagger.tag((InputStream)new ByteArrayInputStream(transcoded.toByteArray()), outputStream);
        }
        catch (TranscoderException e) {
            throw new RuntimeException(e);
        }
    }

    PNGTranscoder createPngTranscoder() {
        return new PNGTranscoder();
    }

    private File writeToFileIfEmpty(File file, FileWriter fileWriter) throws IOException {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                try (FileOutputStream outputStream = new FileOutputStream(file);){
                    fileWriter.write(outputStream);
                }
            }
            catch (IOException e) {
                FileUtils.deleteQuietly((File)file);
                throw new IOException(e);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)file);
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    private String rasterAvatarFileName(Avatar avatar, Avatar.Size size) {
        return this.rasterFileName(avatar.getFileName(), size);
    }

    private String rasterFileName(String baseFilename, Avatar.Size size) {
        return FilenameUtils.removeExtension((String)(size.getParam() + "_" + baseFilename)) + PNG_EXTENSION;
    }

    private String sanitizeFileName(String imageKey) {
        String forbiddenCharacters = "[^\\w+\\.]";
        return imageKey.replaceAll("^" + forbiddenCharacters + "+", "").replaceAll(forbiddenCharacters, "_");
    }

    private PNGTranscoder newPNGTranscoder(Avatar.Size size) {
        PNGTranscoder transcoder = this.createPngTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, Float.valueOf(size.getPixels()));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, Float.valueOf(size.getPixels()));
        return transcoder;
    }

    private static interface FileWriter {
        public void write(FileOutputStream var1) throws IOException;
    }
}

