/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.web.ServletContextProvider;
import com.metainf.jira.plugin.emailissue.attachment.AttachmentContentProvider;
import com.metainf.jira.plugin.emailissue.mail.ByteArrayDataSource;
import com.metainf.jira.plugin.emailissue.mail.DelegatingDataSource;
import com.metainf.jira.plugin.emailissue.mail.FileDataSourceWithName;
import com.metainf.jira.plugin.emailissue.template.JetiAvatarTranscoder;
import com.metainf.jira.plugin.emailissue.util.Downloader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImageURIResolver {
    private Logger logger = Logger.getLogger(ImageURIResolver.class);
    private String baseUrl;
    private String modifiedBaseUrl;
    private static final Pattern imgtag = Pattern.compile("<img\\b[^>]*src=\"[^>]*>(.*?)");
    private static final Pattern atag = Pattern.compile("<a\\b[^>]*href=\"[^>]*/secure/attachment/[^>]*>(.*?)");
    private static final Pattern groupedImgtag = Pattern.compile("(<img\\b[^>]*)(src=\")([^\"]*)(\")(.*?)(>)");
    private static final Pattern src = Pattern.compile("src=\"[^>]*\"");
    private static final Pattern href = Pattern.compile("href=\"[^>]*\"");
    public static final Pattern iconsURLPattern = Pattern.compile(".*/images/icons/(.*)/(.*)");
    public static final Pattern mailIconsURLPattern = Pattern.compile(".*/images/mail/.*");
    public static final String avatarURL = "/secure/useravatar";
    public static final Pattern avatarURLPattern = Pattern.compile("/secure/useravatar\\?.*avatarId=([0-9]+)");
    public static final Pattern viewAvatarURLPattern = Pattern.compile("/secure/viewavatar\\?.*avatarId=([0-9]+).*");
    public static final String attachment = "/secure/attachment/";
    private static final String attachmentIdPattern = "(src=\".*)(/secure/attachment/)([0-9]{1,})(.*)";
    private static final String attachmentIdInHrefPattern = "(href=\".*)(/secure/attachment/)([0-9]{1,})(.*)";
    public static final String thumbnail = "/secure/thumbnail/";
    private static final String thumbnailIdPattern = "(src=\".*)(/secure/thumbnail/)([0-9]{1,})(.*)/_thumb.*";
    public static final String jEditorAttachment = "/plugins/servlet/jeditor_attached_image_provider";
    private final AttachmentManager attachmentManager;
    private final AvatarManager avatarManager;
    private final JetiAvatarTranscoder avatarTranscoder;
    private List<ImageToDataSourceConverter> dataSourceConverters = Arrays.asList(new EmbeddedImageConverter(), new UploadedImageConverter(), new JeditorAttachedImageConverter(), new AvatarConverter(), new IconsConverter(), new ViewAvatarConverter());

    public ImageURIResolver(String baseUrl) {
        this.attachmentManager = ComponentAccessor.getAttachmentManager();
        this.avatarManager = ComponentAccessor.getAvatarManager();
        AvatarTagger avatarTagger = (AvatarTagger)ComponentAccessor.getComponentOfType(AvatarTagger.class);
        JetiAvatarTranscoder jetiAvatarTranscoder = this.avatarTranscoder = avatarTagger == null ? null : new JetiAvatarTranscoder(avatarTagger);
        if (baseUrl != null) {
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            this.baseUrl = baseUrl;
            if (baseUrl.lastIndexOf("/") > 8) {
                baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
            }
        }
        this.modifiedBaseUrl = baseUrl == null ? "" : baseUrl;
    }

    public String resolve(String html) {
        String result = new String(html);
        try {
            if (StringUtils.isNotEmpty((String)html)) {
                Matcher imgMatcher = imgtag.matcher(html);
                while (imgMatcher.find()) {
                    String srcAttribute;
                    String img = imgMatcher.group();
                    Matcher srcMatcher = src.matcher(img);
                    if (!srcMatcher.find() || (srcAttribute = srcMatcher.group()) == null || srcAttribute.toLowerCase().startsWith("src=\"http") || srcAttribute.toLowerCase().startsWith("src=\"data:image") || srcAttribute.toLowerCase().startsWith("src=\"cid")) continue;
                    String correctedSrc = "src=\"" + this.modifiedBaseUrl + srcAttribute.substring(5);
                    String correctedImg = img.replace(srcAttribute, correctedSrc);
                    result = result.replace(img, correctedImg);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String resolve(String html, String imgSource, String newImgSource) {
        String result = new String(html);
        if (StringUtils.isNotBlank((String)imgSource) && StringUtils.isNotBlank((String)newImgSource)) {
            try {
                if (StringUtils.isNotEmpty((String)html)) {
                    Matcher imgMatcher = imgtag.matcher(html);
                    while (imgMatcher.find()) {
                        String srcAttribute;
                        String img = imgMatcher.group();
                        Matcher srcMatcher = src.matcher(img);
                        if (!srcMatcher.find() || (srcAttribute = srcMatcher.group()) == null || !srcAttribute.contains(imgSource) || srcAttribute.toLowerCase().startsWith("src=\"data:image") || srcAttribute.toLowerCase().startsWith("src=\"cid")) continue;
                        String correctedSrc = srcAttribute.replace(imgSource, newImgSource);
                        String correctedImg = img.replace(srcAttribute, correctedSrc);
                        result = result.replace(img, correctedImg);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public Set<Attachment> resolveMissingAttachments(String html, Collection<Attachment> issueAttachments) {
        HashSet<Attachment> missingAttachments = new HashSet<Attachment>();
        boolean i = false;
        try {
            if (StringUtils.isNotEmpty((String)html)) {
                Matcher imgMatcher = imgtag.matcher(html);
                while (imgMatcher.find()) {
                    Attachment attachment;
                    Matcher srcMatcher;
                    String img = imgMatcher.group();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Resolve missing attachments img: " + img));
                    }
                    if (!(srcMatcher = src.matcher(img)).find()) continue;
                    String srcAttribute = srcMatcher.group();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Resolve missing attachments: " + srcAttribute));
                    }
                    if (srcAttribute.contains(attachment)) {
                        try {
                            Long attachmentId = Long.parseLong(srcAttribute.replaceAll(attachmentIdPattern, "$3"));
                            Attachment attachment2 = this.findAttachmentById(attachmentId, issueAttachments);
                            if (attachment2 == null) continue;
                            missingAttachments.add(attachment2);
                        }
                        catch (NumberFormatException e) {
                            this.logger.info((Object)e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    if (srcAttribute.contains(thumbnail)) {
                        try {
                            Long attachmentId = Long.parseLong(srcAttribute.replaceAll(thumbnailIdPattern, "$3"));
                            Attachment attachment3 = this.findAttachmentById(attachmentId, issueAttachments);
                            if (attachment3 == null) continue;
                            missingAttachments.add(attachment3);
                        }
                        catch (NumberFormatException e) {
                            this.logger.info((Object)e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    if (!srcAttribute.contains(jEditorAttachment)) continue;
                    int start = srcAttribute.indexOf("attachName=");
                    int end = srcAttribute.indexOf("&", start);
                    String attachmentName = srcAttribute.substring(start + "attachName=".length(), end);
                    if (!StringUtils.isNotBlank((String)attachmentName) || (attachment = this.findLastAttachmentByName(attachmentName, issueAttachments)) == null) continue;
                    missingAttachments.add(attachment);
                }
                Matcher acnhorMatcher = atag.matcher(html);
                while (acnhorMatcher.find()) {
                    Matcher hrefMatcher;
                    String anchor = acnhorMatcher.group();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Resolve missing attachments img: " + anchor));
                    }
                    if (!(hrefMatcher = href.matcher(anchor)).find()) continue;
                    String hrefAttribute = hrefMatcher.group();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Resolve missing attachments: " + hrefAttribute));
                    }
                    if (!hrefAttribute.contains(attachment)) continue;
                    try {
                        Long attachmentId = Long.parseLong(hrefAttribute.replaceAll(attachmentIdInHrefPattern, "$3"));
                        Attachment attachment = this.findAttachmentById(attachmentId, issueAttachments);
                        if (attachment == null) continue;
                        missingAttachments.add(attachment);
                    }
                    catch (NumberFormatException e) {
                        this.logger.info((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("ImageURIResolver caught error during image resolving: " + e), (Throwable)e);
        }
        return missingAttachments;
    }

    public static void main(String[] args) {
        String html = "<td style=\"color:#505050;font-family:Arial,FreeSans,Helvetica,sans-serif;padding:0;\">\n<img id=\"email-avatar\" src=\"/jira/secure/useravatar?ownerId=tibor&avatarId=10040\" alt=\"\" height=\"48\" />\n\t<div id=\"email-action\" style=\"padding: 0 0 8px 0;font-size:12px;line-height:18px;\">\n<img id=\"email-avatar\" src=\"/jira/secure/useravatar?ownerId=tibor&avatarId=10040\" alt=\"\" height=\"48\" />";
        String base = "BASE/";
        ImageURIResolver r = new ImageURIResolver(base);
        System.out.println(r.resolve(html));
    }

    public Set<String> resolveImageLinks(String body) {
        HashSet<String> links = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)body)) {
            Matcher imgMatcher = groupedImgtag.matcher(body);
            while (imgMatcher.find()) {
                String imgSrc;
                if (imgMatcher.groupCount() <= 2 || !StringUtils.isNotBlank((String)(imgSrc = (imgSrc = imgMatcher.group(3)) == null ? null : imgSrc.trim())) || imgSrc.startsWith("cid:")) continue;
                links.add(imgSrc);
            }
        }
        return links;
    }

    public DataSource downloadImage(String imageLink, Collection<Attachment> attachments, AttachmentContentProvider attachmentContentProvider) {
        DataSource ds = null;
        try {
            if (StringUtils.isNotBlank((String)imageLink)) {
                imageLink = imageLink.replaceAll("&amp;", "&");
                this.logger.debug((Object)("Downloading image: " + imageLink));
                if (StringUtils.isNotBlank((String)imageLink)) {
                    String url = imageLink.startsWith("http") ? imageLink : this.modifiedBaseUrl + imageLink;
                    ds = new Downloader<DataSource>(url, 30000).download(new Downloader.ResponseHandler<DataSource>(){

                        @Override
                        public DataSource onResponse(Downloader.Response response) throws IOException {
                            ByteArrayDataSource dataSource = null;
                            if (response.isOk() && (response.getContentType() == null || response.getContentType().contains("image")) && response.getResponseLength() != 0L) {
                                dataSource = new ByteArrayDataSource("embedded-image-" + new SecureRandom().nextLong(), response.getContentType(), response.getHttp().getResponseBodyAsStream());
                            }
                            return dataSource;
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e.getMessage(), (Throwable)e);
        }
        this.logger.debug((Object)("Downloaded image?: " + ds));
        return ds;
    }

    private Attachment findLastAttachmentByName(String attachmentName, Collection<Attachment> attachments) {
        try {
            attachmentName = URLDecoder.decode(attachmentName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Attachment result = null;
        for (Attachment a : attachments) {
            if (!attachmentName.equals(a.getFilename()) || result != null && !result.getCreated().before(a.getCreated())) continue;
            result = a;
            break;
        }
        return result;
    }

    private Attachment findAttachmentById(Long attachmentId, Collection<Attachment> attachments) {
        for (Attachment a : attachments) {
            if (!a.getId().equals(attachmentId)) continue;
            return a;
        }
        return null;
    }

    public boolean isAvatarUrl(String url) {
        return url != null && url.contains(avatarURL);
    }

    public boolean isEmbeddedImage(String url) {
        return url != null && url.toLowerCase().startsWith("data:");
    }

    public DataSource obtainAvatarImage(String url) {
        return null;
    }

    public DataSource prepareEmbeddedImageForInlining(String imageLink) {
        ByteArrayDataSource source = null;
        if (this.isEmbeddedImage(imageLink)) {
            String base64EncodedImage;
            int pos = imageLink.indexOf(":") + 1;
            int pos2 = imageLink.indexOf(";", pos);
            String mimeType = imageLink.substring(pos, pos2);
            int pos3 = imageLink.indexOf(",", pos2);
            String encoding = imageLink.substring(pos2 + 1, pos3);
            if ("base64".equalsIgnoreCase(encoding) && StringUtils.isNotBlank((String)(base64EncodedImage = imageLink.substring(pos3 + 1)))) {
                byte[] imageData = Base64.decodeBase64((String)base64EncodedImage);
                try {
                    source = new ByteArrayDataSource("image" + new SecureRandom().nextLong(), mimeType, new ByteArrayInputStream(imageData));
                }
                catch (IOException e) {
                    source = null;
                }
            }
        }
        return source;
    }

    public boolean isJEditorUploadedImage(String imageLink) {
        return imageLink != null && imageLink.contains("/plugins/servlet/jeditor_file_provider?") && imageLink.contains("imgId=");
    }

    public DataSource obtainJEditorUploadedImage(String imageLink) {
        DataSource source = null;
        if (this.isJEditorUploadedImage(imageLink)) {
            // empty if block
        }
        return source;
    }

    public DataSource resolveToDataSource(String imageLink) {
        DataSource source = null;
        try {
            ImageToDataSourceConverter converter;
            Iterator<ImageToDataSourceConverter> iterator = this.dataSourceConverters.iterator();
            while (iterator.hasNext() && (source = (converter = iterator.next()).convert(imageLink)) == null) {
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e);
        }
        return source;
    }

    private class ViewAvatarConverter
    implements ImageToDataSourceConverter {
        private ViewAvatarConverter() {
        }

        @Override
        public DataSource convert(String imageLink) {
            try {
                Avatar avatar;
                String id;
                Matcher m;
                final DelegatingDataSource source = new DelegatingDataSource();
                if (imageLink != null && (m = viewAvatarURLPattern.matcher(imageLink)).find() && StringUtils.isNotBlank((String)(id = m.group(1))) && (avatar = ImageURIResolver.this.avatarManager.getById(Long.valueOf(Long.parseLong(id)))) != null) {
                    ImageURIResolver.this.avatarManager.readAvatarData(avatar, AvatarManager.ImageSize.NORMAL, (Consumer)new Consumer<InputStream>(){

                        public void consume(@Nonnull InputStream is) {
                            try {
                                source.setDelegate(new ByteArrayDataSource("image" + new SecureRandom().nextLong(), avatar.getContentType(), is));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                return source.getDelegate() == null ? null : source.getDelegate();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private class IconsConverter
    implements ImageToDataSourceConverter {
        private String resourceBase = "resources/images/icons/";

        private IconsConverter() {
        }

        @Override
        public DataSource convert(String imageLink) {
            try {
                ByteArrayDataSource source = null;
                if (imageLink != null) {
                    Matcher m = iconsURLPattern.matcher(imageLink);
                    Matcher m2 = mailIconsURLPattern.matcher(imageLink);
                    if (m.find() || m2.find()) {
                        URI uri = new URI(imageLink);
                        if (uri.isAbsolute()) {
                            imageLink = StringUtils.removeStartIgnoreCase((String)imageLink, (String)ImageURIResolver.this.baseUrl);
                        }
                        ServletContext servletContext = ServletContextProvider.getServletContext();
                        InputStream resourceStream = servletContext.getResourceAsStream(imageLink);
                        String mimeType = servletContext.getMimeType(imageLink);
                        source = new ByteArrayDataSource("image" + new SecureRandom().nextLong(), mimeType, resourceStream);
                    }
                }
                return source;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private class AvatarConverter
    implements ImageToDataSourceConverter {
        private AvatarConverter() {
        }

        @Override
        public DataSource convert(String imageLink) {
            try {
                Avatar avatar;
                String id;
                Matcher m;
                DelegatingDataSource source = new DelegatingDataSource();
                if (imageLink != null && ImageURIResolver.this.isAvatarUrl(imageLink) && (m = avatarURLPattern.matcher(imageLink)).find() && StringUtils.isNotBlank((String)(id = m.group(1))) && (avatar = ImageURIResolver.this.avatarManager.getById(Long.valueOf(Long.parseLong(id)))) != null) {
                    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageURIResolver.this.avatarManager.readAvatarData(avatar, Avatar.Size.NORMAL, (Consumer)new Consumer<InputStream>(){

                        public void consume(@Nonnull InputStream is) {
                            try {
                                IOUtils.copy((InputStream)is, (OutputStream)baos);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                    source.setDelegate(new ByteArrayDataSource("image" + new SecureRandom().nextLong(), avatar.getContentType(), is));
                }
                return source.getDelegate() == null ? null : source.getDelegate();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private class JeditorAttachedImageConverter
    implements ImageToDataSourceConverter {
        private JeditorAttachedImageConverter() {
        }

        @Override
        public DataSource convert(String imageLink) {
            FileDataSourceWithName source = null;
            if (imageLink != null && imageLink.contains("/plugins/servlet/jeditor_attached_image_provider?") && imageLink.contains("attachId=")) {
                int p2;
                int p1 = imageLink.indexOf("attachId=") + "attachId=".length();
                String attachIdString = imageLink.substring(p1, p2 = imageLink.indexOf("&", p1));
                if (StringUtils.isBlank((String)attachIdString)) {
                    return null;
                }
                Long attachmentId = Long.parseLong(attachIdString);
                Attachment attachment = ImageURIResolver.this.attachmentManager.getAttachment(attachmentId);
                if (attachment != null) {
                    File file = AttachmentUtils.getAttachmentFile((Attachment)attachment);
                    String path = file == null || !file.exists() ? null : file.getAbsolutePath();
                    source = StringUtils.isBlank((String)path) ? null : new FileDataSourceWithName(file, attachment.getFilename());
                }
            }
            return source;
        }
    }

    private class UploadedImageConverter
    implements ImageToDataSourceConverter {
        private UploadedImageConverter() {
        }

        @Override
        public DataSource convert(String imageLink) {
            FileDataSourceWithName source = null;
            if (imageLink != null && imageLink.contains("/plugins/servlet/jeditor_file_provider?") && imageLink.contains("imgId=")) {
                int p2;
                int p1 = imageLink.indexOf("imgId=") + "imgId=".length();
                String imgId = imageLink.substring(p1, p2 = imageLink.indexOf("&", p1));
                String date = imgId == null ? null : imgId.substring(8, 16);
                String year = date.substring(0, 4);
                String month = date.substring(4, 6);
                String day = date.substring(6);
                AttachmentPathManager attachmentPathManager = ComponentAccessor.getAttachmentPathManager();
                String ckUploadFilePath = attachmentPathManager.getAttachmentPath() + "/ck_upload_store/" + year + "/" + month + "/" + day + "/" + imgId;
                File ckUploadFile = new File(ckUploadFilePath);
                p1 = imageLink.indexOf("fileName=") + "fileName=".length();
                String fileName = imageLink.substring(p1);
                if (ckUploadFile.exists() && ckUploadFile.isFile()) {
                    source = new FileDataSourceWithName(ckUploadFile, fileName);
                }
            }
            return source;
        }
    }

    private class EmbeddedImageConverter
    implements ImageToDataSourceConverter {
        private EmbeddedImageConverter() {
        }

        @Override
        public DataSource convert(String imageLink) {
            ByteArrayDataSource source = null;
            if (imageLink != null && imageLink.toLowerCase().startsWith("data:")) {
                String base64EncodedImage;
                int pos = imageLink.indexOf(":") + 1;
                int pos2 = imageLink.indexOf(";", pos);
                String mimeType = imageLink.substring(pos, pos2);
                int pos3 = imageLink.indexOf(",", pos2);
                String encoding = imageLink.substring(pos2 + 1, pos3);
                if ("base64".equalsIgnoreCase(encoding) && StringUtils.isNotBlank((String)(base64EncodedImage = imageLink.substring(pos3 + 1)))) {
                    byte[] imageData = Base64.decodeBase64((String)base64EncodedImage);
                    try {
                        source = new ByteArrayDataSource("image" + new SecureRandom().nextLong(), mimeType, new ByteArrayInputStream(imageData));
                    }
                    catch (IOException e) {
                        source = null;
                    }
                }
            }
            return source;
        }
    }

    private static interface ImageToDataSourceConverter {
        public DataSource convert(String var1);
    }
}

