/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.mail.TemplateIssue;
import com.atlassian.jira.util.JiraDurationUtils;
import com.metainf.jira.plugin.emailissue.template.ImageURIResolver;
import java.util.regex.Pattern;

public class ImageSafeTemplateIssue
extends TemplateIssue {
    private String baseUrl;
    private Pattern imgtag = Pattern.compile("<img\\b[^>]*src=\"[^>]*>(.*?)/>");
    private Pattern src = Pattern.compile("src=\"[^>]*\"");
    private ImageURIResolver imageURIResolver;

    public ImageSafeTemplateIssue(Issue issue, String baseUrl, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, CustomFieldManager customFieldManager, JiraDurationUtils jiraDurationUtils, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory) {
        super(issue, fieldLayoutManager, rendererManager, customFieldManager, jiraDurationUtils, aggregateTimeTrackingCalculatorFactory);
        if (baseUrl != null) {
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            if (baseUrl.lastIndexOf("/") > 8) {
                this.baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
            }
        }
        this.imageURIResolver = new ImageURIResolver(this.baseUrl);
    }

    public String getHtmlDescription() {
        String html = super.getHtmlDescription();
        String result = this.imageURIResolver.resolve(html);
        return result;
    }
}

