/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.mail.TemplateIssue;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskDetails;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManagerImpl;
import com.metainf.jira.plugin.emailissue.template.FieldRenderer;
import com.metainf.jira.plugin.emailissue.template.Renderer;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class FieldRendererImpl
implements FieldRenderer {
    private final CustomFieldManager customFieldManager;
    private final JiraAuthenticationContext authContext;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final UserPropertyManager userPropertyManager;
    private final IssueTransitioner issueTransitioner;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final ServiceDeskManager serviceDeskManager;

    public FieldRendererImpl(CustomFieldManager customFieldManager, JiraAuthenticationContext authContext, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, UserPropertyManager userPropertyManager, IssueTransitioner issueTransitioner, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.customFieldManager = customFieldManager;
        this.authContext = authContext;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.userPropertyManager = userPropertyManager;
        this.issueTransitioner = issueTransitioner;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.serviceDeskManager = new ServiceDeskManagerImpl(ComponentAccessor.getProjectManager(), ComponentAccessor.getOfBizDelegator(), ComponentAccessor.getPluginAccessor(), (ProjectRoleManager)ComponentAccessor.getComponent(ProjectRoleManager.class), null, null);
    }

    @Override
    public String renderCustomField(Issue issue, String fieldKey) {
        if (issue == null || StringUtils.isEmpty((String)fieldKey)) {
            return null;
        }
        CustomField cf = this.customFieldManager.getCustomFieldObject(fieldKey);
        if (cf == null) {
            return null;
        }
        Object value = issue.getCustomFieldValue(cf);
        if (value != null && value instanceof String) {
            String stringValue = (String)value;
            String renderType = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem((OrderableField)cf).getRendererType();
            String renderedValue = StringUtils.isBlank((String)renderType) || Renderer.getByKey(renderType) == Renderer.TEXT ? stringValue : this.rendererManager.getRenderedContent(renderType, stringValue, issue.getIssueRenderContext());
            return renderedValue;
        }
        return value == null ? null : value.toString();
    }

    @Override
    public Object renderCustomFieldAsObject(Issue issue, String fieldKey) {
        if (issue == null || StringUtils.isEmpty((String)fieldKey)) {
            return null;
        }
        CustomField cf = this.customFieldManager.getCustomFieldObject(fieldKey);
        if (cf == null) {
            return null;
        }
        return issue.getCustomFieldValue(cf);
    }

    @Override
    public String renderVersions(Collection<Version> versions) {
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Version> it = versions.iterator();
        while (it.hasNext()) {
            Version v = it.next();
            sb.append(v.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String renderComponents(Collection<ProjectComponent> components) {
        if (components == null || components.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<ProjectComponent> it = components.iterator();
        while (it.hasNext()) {
            ProjectComponent v = it.next();
            sb.append(v.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String renderLabels(Collection<Label> labels) {
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Label> it = labels.iterator();
        while (it.hasNext()) {
            Label v = it.next();
            sb.append(v.getLabel());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String renderSecurityLevel(GenericValue securityLevel) {
        return securityLevel == null ? null : securityLevel.getString("name");
    }

    @Override
    public String renderIssueConstant(IssueConstant issueConstant) {
        return issueConstant == null ? null : issueConstant.getNameTranslation();
    }

    @Override
    public String renderUser(ApplicationUser user) {
        return user == null ? null : user.getDisplayName();
    }

    @Override
    public String renderUser(User user) {
        return this.renderUser(ApplicationUsers.from((User)user));
    }

    @Override
    public String renderDateTime(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        return this.dateTimeFormatterFactory.formatter().format((Date)ts);
    }

    @Override
    public String renderEstimate(TemplateIssue ti, I18nHelper i18n) {
        return ti == null ? null : ti.getNiceTimeOriginalEstimate(i18n);
    }

    @Override
    public String renderRemainingEstimate(TemplateIssue ti, I18nHelper i18n) {
        return ti == null ? null : ti.getNiceTimeOriginalEstimate(i18n);
    }

    @Override
    public String renderWorklog(TemplateIssue ti, I18nHelper i18n) {
        return ti == null ? null : ti.getNiceTimeSpent(i18n);
    }

    public String asHtml(String value) {
        return value;
    }

    public PropertySet getUserProperties(ApplicationUser user) {
        return this.userPropertyManager.getPropertySet(user);
    }

    public PropertySet getUserProperties(User user) {
        if (user != null) {
            return this.userPropertyManager.getPropertySet(ApplicationUsers.from((User)user));
        }
        return null;
    }

    @Override
    public I18nHelper getI18nBean(String localeString) {
        I18nHelper i18n = this.authContext.getI18nHelper();
        if (StringUtils.isNotBlank((String)localeString)) {
            Locale locale = null;
            String[] localeParts = localeString.split("_");
            locale = localeParts.length > 2 ? new Locale(localeParts[0], localeParts[1], localeParts[2]) : (localeParts.length == 2 ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeString));
            if (locale != null) {
                i18n = new I18nBean(locale);
            }
        }
        return i18n;
    }

    @Override
    public List reverse(List list) {
        if (list != null) {
            Collections.reverse(list);
        }
        return list;
    }

    @Override
    public List<ActionDescriptor> getWorkflowActions(Issue issue) {
        return this.issueTransitioner.getAllTransitions(issue);
    }

    @Override
    public String getLinkToCustomerPortal(Issue issue) {
        ServiceDeskDetails desk;
        String relativeLink = null;
        if (issue != null && (desk = this.serviceDeskManager.getServiceDeskDetails(issue.getProjectId())) != null) {
            relativeLink = this.serviceDeskManager.getLinkToCustomerPortal(desk);
        }
        return relativeLink;
    }

    @Override
    public String getLinkToIssueInCustomerPortal(Issue issue) {
        String relativeLink = this.getLinkToCustomerPortal(issue);
        return StringUtils.isNotBlank((String)relativeLink) ? relativeLink + "/" + issue.getKey() : null;
    }
}

