/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class FieldFormatters {
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public FieldFormatters(DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    public DateTimeFormatter getJiraDateTimeFormatter() {
        return this.dateTimeFormatterFactory.formatter();
    }

    public DateTimeFormatter getJiraDateTimeFormatter(String styleName) {
        try {
            return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.valueOf((String)styleName));
        }
        catch (Exception e) {
            return this.getJiraDateTimeFormatter();
        }
    }

    public DateFormat getJavaDateFormat() {
        return DateFormat.getDateInstance();
    }

    public DateFormat getJavaDateFormat(int style) {
        return DateFormat.getDateInstance(style);
    }

    public DateFormat getJavaDateFormat(int style, String locale) {
        String[] localeParts;
        String[] stringArray = localeParts = StringUtils.isNotBlank((String)locale) ? locale.split("_") : null;
        if (localeParts == null) {
            return this.getJavaDateFormat(style);
        }
        if (localeParts.length == 1) {
            return DateFormat.getDateInstance(style, new Locale(localeParts[0]));
        }
        if (localeParts.length == 2) {
            return DateFormat.getDateInstance(style, new Locale(localeParts[0], localeParts[1]));
        }
        return DateFormat.getDateInstance(style, new Locale(localeParts[0], localeParts[1], localeParts[2]));
    }

    public DateFormat getJavaDateTimeFormat() {
        return DateFormat.getDateTimeInstance();
    }

    public DateFormat getJavaDateTimeFormat(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle);
    }

    public DateFormat getJavaDateTimeFormat(int dateStyle, int timeStyle, String locale) {
        String[] localeParts;
        String[] stringArray = localeParts = StringUtils.isNotBlank((String)locale) ? locale.split("_") : null;
        if (localeParts == null) {
            return this.getJavaDateTimeFormat(dateStyle, timeStyle);
        }
        if (localeParts.length == 1) {
            return DateFormat.getDateTimeInstance(dateStyle, timeStyle, new Locale(localeParts[0]));
        }
        if (localeParts.length == 2) {
            return DateFormat.getDateTimeInstance(dateStyle, timeStyle, new Locale(localeParts[0], localeParts[1]));
        }
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, new Locale(localeParts[0], localeParts[1], localeParts[2]));
    }

    public DateFormat getJavaDateTimeFormat(String pattern) {
        return StringUtils.isNotBlank((String)pattern) ? new SimpleDateFormat(pattern) : DateFormat.getDateTimeInstance();
    }

    public String formatSafely(DateFormat dateFormat, Object value) {
        try {
            if (value instanceof Date) {
                return this.formatSafely(dateFormat, (Date)value);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String formatSafely(DateFormat dateFormat, Date value) {
        try {
            return dateFormat.format(value);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String formatSafely(DateTimeFormatter dateFormat, Date value) {
        try {
            return dateFormat.format(value);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String formatSafely(DateTimeFormatter dateFormat, Object value) {
        try {
            if (value instanceof Date) {
                return this.formatSafely(dateFormat, (Date)value);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

