/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.sal.api.ApplicationProperties;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.audit.AuditLogBean;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.template.ImageSafeTemplateIssue;
import java.util.ArrayList;
import java.util.List;

public class EnhancedTemplateIssue
extends ImageSafeTemplateIssue {
    private final CustomFieldManager customFieldManager;
    private final IssueLinkManager issueLinkManager;
    private final JiraAuthenticationContext authContext;
    private final AuditLogDao auditLogDao;
    private final TemplateDao templateDao;
    private final AvatarService avatarService;
    private final UserResolver userResolver;
    private final ApplicationProperties applicationProperties;
    private final DateTimeFormatter dateTimeFormatter;
    private final I18nHelper i18nHelper;

    public EnhancedTemplateIssue(Issue issue, String baseUrl, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, CustomFieldManager customFieldManager, JiraDurationUtils jiraDurationUtils, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory, IssueLinkManager issueLinkManager, JiraAuthenticationContext authContext, AuditLogDao auditLogDao, AvatarService avatarService, UserResolver userResolver, ApplicationProperties applicationProperties, DateTimeFormatter dateTimeFormatter, TemplateDao templateDao) {
        super(issue, baseUrl, fieldLayoutManager, rendererManager, customFieldManager, jiraDurationUtils, aggregateTimeTrackingCalculatorFactory);
        this.issueLinkManager = issueLinkManager;
        this.authContext = authContext;
        this.auditLogDao = auditLogDao;
        this.avatarService = avatarService;
        this.userResolver = userResolver;
        this.applicationProperties = applicationProperties;
        this.dateTimeFormatter = dateTimeFormatter;
        this.i18nHelper = authContext.getI18nHelper();
        this.templateDao = templateDao;
        this.customFieldManager = customFieldManager;
    }

    public LinkCollection getLinkCollection() {
        LinkCollection lc = this.issueLinkManager.getLinkCollection((Issue)this, this.authContext.getLoggedInUser());
        for (IssueLinkType lt : lc.getLinkTypes()) {
            String outw;
            List inwards = lc.getInwardIssues(lt.getName());
            List outwards = lc.getOutwardIssues(lt.getName());
            String inw = lt.getInward();
            inw = outw = lt.getOutward();
        }
        return lc.getLinkTypes() == null || lc.getLinkTypes().isEmpty() ? null : lc;
    }

    public List<AuditLogBean> getAuditLog() {
        ArrayList<AuditLogBean> auditLogBeans = new ArrayList<AuditLogBean>();
        AuditLogEntry[] hits = (AuditLogEntry[])this.auditLogDao.filterAndOrder("ISSUE_ID = ?", "ID DESC", new Object[]{this.getId()});
        if (hits != null && hits.length > 0) {
            for (AuditLogEntry ale : hits) {
                AuditLogBean alb = new AuditLogBean((Issue)this, ale, this.dateTimeFormatter, this.i18nHelper, this.avatarService, this.userResolver, this.applicationProperties, this.templateDao);
                auditLogBeans.add(alb);
            }
        }
        return auditLogBeans;
    }

    public List<Comment> getComments() {
        return ComponentAccessor.getCommentManager().getComments((Issue)this);
    }

    public List<CustomField> getCustomFields() {
        return this.customFieldManager.getCustomFieldObjects((Issue)this);
    }

    public Comment getLastComment() {
        List<Comment> comments = this.getComments();
        return comments.isEmpty() ? null : comments.get(comments.size() - 1);
    }

    public List<Worklog> getWorklogs() {
        return ComponentAccessor.getWorklogManager().getByIssue((Issue)this);
    }
}

