/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.template;

import com.metainf.jira.plugin.emailissue.util.FileUtils;

public enum EmailTemplateTheme {
    DEFAULT("all-details.vm", "Default", false),
    ALL_DETAILS("all-details.vm", "All Details", false),
    ISSUE_COMMENTED("issue-commented.vm", "Issue Commented", false),
    ISSUE_MODIFIED("issue-modified.vm", "Issue Modified", false),
    WORK_LOGGED("work-logged.vm", "Work Logged", false),
    SD_WELCOME("sd-welcome.vm", "Service Desk Customer Invitation", true),
    SD_ACKNOWLEDGE("sd-acknowledge.vm", "Service Desk Auto Acknowledge", true),
    SD_PARTICIPANT_ADDED("sd-participant-added.vm", "Service Desk Request Participant Added Notification", true),
    SD_REQUEST_CREATED("sd-request-created.vm", "Service Desk Request Created", true),
    SD_REQUEST_UPDATED("sd-request-updated.vm", "Service Desk Request Updated", true),
    SD_REQUEST_RESOLVED("sd-request-resolved.vm", "Service Desk Request Resolved", true),
    SD_REQUEST_REOPENED("sd-request-reopened.vm", "Service Desk Request Reopened", true),
    SD_REQUEST_COMMENTED("sd-request-commented.vm", "Service Desk Request Commented", true),
    EMPTY("empty.vm", "Empty", true);

    private String themeFile;
    private String category;
    private boolean serviceDeskTheme;

    private EmailTemplateTheme(String themeFile, String category, boolean serviceDeskTheme) {
        this.category = category;
        this.themeFile = themeFile;
        this.serviceDeskTheme = serviceDeskTheme;
    }

    public static EmailTemplateTheme defaultTheme() {
        return DEFAULT;
    }

    public String getSubject() {
        return FileUtils.readFile("templates/themes/subject/" + this.themeFile);
    }

    public String getHtmlBody() {
        return FileUtils.readFile("templates/themes/html/" + this.themeFile);
    }

    public String getTextBody() {
        return FileUtils.readFile("templates/themes/text/" + this.themeFile);
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isServiceDeskTheme() {
        return this.serviceDeskTheme;
    }

    public static EmailTemplateTheme valueOf(String name, EmailTemplateTheme defaultValue) {
        try {
            return EmailTemplateTheme.valueOf(name);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return defaultValue;
        }
    }
}

