/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.searcher;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;

public class DefaultIssueSearcher
implements IssueSearcher {
    private static final String JQL_PATTERN = "({0}) AND (issuekey={1})";
    private final IssueManager issueManager;
    private final IssueIndexManager issueIndexManager;
    private final SearchService searchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public DefaultIssueSearcher(IssueManager issueManager, IssueIndexManager issueIndexManager, SearchService searchService, SearchProvider searchProvider, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueManager = issueManager;
        this.issueIndexManager = issueIndexManager;
        this.searchService = searchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public boolean issueExists(Long issueId) {
        if (issueId == null) {
            return false;
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        boolean exists = false;
        if (user == null) {
            exists = this.issueManager.getIssueObject(issueId) != null;
        } else {
            SearchService.ParseResult pr = this.searchService.parseQuery(user, "id = " + issueId);
            if (!pr.getErrors().hasAnyErrors()) {
                try {
                    exists = this.searchService.searchCount(user, pr.getQuery()) > 0L;
                }
                catch (SearchException searchException) {
                    // empty catch block
                }
            }
        }
        return exists;
    }

    @Override
    public boolean issueMatchesJQL(String jqlQuery, Issue issue) {
        return this.issueMatchesJQL(jqlQuery, issue, false);
    }

    @Override
    public boolean issueMatchesJQLWithoutReindexing(String jqlQuery, Issue issue) {
        boolean matching = this.issueMatchesJQL(jqlQuery, issue, false, false);
        return matching;
    }

    @Override
    public boolean issueMatchesJQL(String jqlQuery, Issue issue, boolean overrideSecurity) {
        boolean matching = this.issueMatchesJQL(jqlQuery, issue, overrideSecurity, true);
        return matching;
    }

    @Override
    public boolean issueMatchesJQLWithoutReindexing(String jqlQuery, Issue issue, boolean overrideSecurity) {
        boolean matching = this.issueMatchesJQL(jqlQuery, issue, overrideSecurity, false);
        return matching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean issueMatchesJQL(String jqlQuery, Issue issue, boolean overrideSecurity, boolean reindexIssue) {
        boolean matching = false;
        if (StringUtils.isNotBlank((String)jqlQuery) && issue != null) {
            String jql = MessageFormat.format(JQL_PATTERN, jqlQuery, issue.getKey());
            try {
                ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser() == null ? issue.getReporter() : this.jiraAuthenticationContext.getLoggedInUser();
                SearchService.ParseResult pr = this.searchService.parseQuery(user, jql);
                if (!pr.getErrors().hasAnyErrors()) {
                    long hitcount = overrideSecurity ? this.searchService.searchCountOverrideSecurity(user, pr.getQuery()) : this.searchService.searchCount(user, pr.getQuery());
                    matching = hitcount > 0L;
                }
            }
            catch (Exception exception) {}
        }
        return matching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Issue singleResult(String jqlQuery, ApplicationUser user) {
        Issue issue = null;
        if (StringUtils.isNotBlank((String)jqlQuery) && user != null) {
            try {
                long hitcount;
                SearchService.ParseResult pr = this.searchService.parseQuery(user, jqlQuery);
                if (!pr.getErrors().hasAnyErrors() && (hitcount = this.searchService.searchCountOverrideSecurity(user, pr.getQuery())) == 1L) {
                    SearchResults hits = this.searchService.searchOverrideSecurity(user, pr.getQuery(), PagerFilter.newPageAlignedFilter((int)0, (int)1));
                    issue = (Issue)hits.getIssues().iterator().next();
                }
            }
            catch (Exception exception) {}
        }
        return issue;
    }

    @Override
    public void reIndexIssue(Issue issue) {
        try {
            if (this.issueIndexManager.isHeld()) {
                this.issueIndexManager.release();
                this.issueIndexManager.reIndex(issue);
                this.issueIndexManager.hold();
            } else {
                this.issueIndexManager.reIndex(issue);
            }
        }
        catch (IndexException indexException) {
            // empty catch block
        }
    }
}

