/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.rest;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.metainf.jira.plugin.emailissue.rest.CacheControls;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/validate")
public class ValidationResource {
    private final SearchService searchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ValidationResource(SearchService searchService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.searchService = searchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Path(value="/jql")
    @Produces(value={"text/plain"})
    @GET
    public Response validateJQL(@QueryParam(value="jql") String jql) {
        SearchService.ParseResult pr;
        if (StringUtils.isNotBlank((String)jql) && (pr = this.searchService.parseQuery(this.jiraAuthenticationContext.getLoggedInUser(), jql)).getErrors().hasAnyErrors()) {
            return Response.ok((Object)pr.getErrors().getErrorMessages().toString()).cacheControl(CacheControls.NO_CACHE).build();
        }
        return Response.ok((Object)Boolean.TRUE.toString()).cacheControl(CacheControls.NO_CACHE).build();
    }
}

