/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.rest;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.rest.CacheControls;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk")
public class ServiceDeskResource {
    private final JiraAuthenticationContext authenticationContext;
    private final ServiceDeskManager serviceDeskManager;

    public ServiceDeskResource(JiraAuthenticationContext authenticationContext, ServiceDeskManager serviceDeskManager) {
        this.authenticationContext = authenticationContext;
        this.serviceDeskManager = serviceDeskManager;
    }

    @Path(value="/requesttypes/{projectId}/{issueTypeId}")
    @GET
    @Produces(value={"application/json"})
    public Response getRequestTypes(@PathParam(value="projectId") Long projectId, @PathParam(value="issueTypeId") String issueTypeId) {
        try {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            if (user == null) {
                throw new RuntimeException("User not logged in");
            }
            Collection<Object> requestTypes = Collections.emptyList();
            if (this.serviceDeskManager.isServiceDeskProject(projectId)) {
                requestTypes = this.serviceDeskManager.getCustomerRequestTypes(projectId, issueTypeId);
            }
            return Response.ok(requestTypes).cacheControl(CacheControls.NO_CACHE).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControls.NO_CACHE).build();
        }
    }
}

