/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.rest;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.metainf.jira.plugin.emailissue.action.AddAttachmentType;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.api.EmailDefinitionApi;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/email")
public class EmailResource {
    private Logger logger = Logger.getLogger(EmailResource.class);
    private final JiraAuthenticationContext authenticationContext;
    private final EmailSender emailSender;
    private final CustomFieldManager customFieldManager;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final IssueManager issueManager;
    private final UserResolver userResolver;
    private final TemplateDao templateDao;

    public EmailResource(JiraAuthenticationContext authenticationContext, EmailSender emailSender, CustomFieldManager customFieldManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, IssueManager issueManager, UserResolver userResolver, TemplateDao templateDao) {
        this.authenticationContext = authenticationContext;
        this.emailSender = emailSender;
        this.customFieldManager = customFieldManager;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.issueManager = issueManager;
        this.userResolver = userResolver;
        this.templateDao = templateDao;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response sendEmail(EmailDefinitionApi emailDefinition) {
        try {
            if (this.authenticationContext.isLoggedInUser() && emailDefinition != null) {
                Issue issue = this.getIssue(emailDefinition.getIssue());
                if (issue != null) {
                    EmailDefinition def = this.toEmailDefinition(issue, emailDefinition);
                    this.emailSender.sendEmail(def, this.authenticationContext.getLoggedInUser());
                } else {
                    throw new IllegalArgumentException("Issue not found for id or key: " + emailDefinition.getIssue());
                }
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    private EmailDefinition toEmailDefinition(Issue issue, EmailDefinitionApi emailDefinition) {
        String to = this.getUsersAndEmailAddresses(emailDefinition.getTo());
        String cc = this.getUsersAndEmailAddresses(emailDefinition.getCc());
        String bcc = this.getUsersAndEmailAddresses(emailDefinition.getBcc());
        List<Recipient> toRecipients = this.getRecipients(emailDefinition.getTo());
        List<Recipient> ccRecipients = this.getRecipients(emailDefinition.getCc());
        List<Recipient> bccRecipients = this.getRecipients(emailDefinition.getBcc());
        Template template = this.getEmailTemplate(emailDefinition.getEmailTemplate());
        List<Attachment> attachments = this.getAttachments(issue, emailDefinition);
        EmailDefinitionImpl def = new EmailDefinitionImpl(issue, toRecipients, ccRecipients, bccRecipients, emailDefinition.getEmailOptions() == null ? new EmailOptions() : emailDefinition.getEmailOptions(), emailDefinition.getEmailBody(), emailDefinition.getEmailSubject(), this.authenticationContext.getLoggedInUser(), to, cc, bcc, this.authenticationContext.getI18nHelper(), null, EmailSource.API);
        def.setEmailTemplate(template);
        def.setAttachmentObjects(attachments == null || attachments.isEmpty() ? null : attachments.toArray(new Attachment[0]));
        if (emailDefinition.getPayload() != null && !emailDefinition.getPayload().isEmpty()) {
            if (def.getVelocityContext() == null) {
                def.setVelocityContext(new HashMap<String, Object>(emailDefinition.getPayload()));
            } else {
                def.getVelocityContext().putAll(emailDefinition.getPayload());
            }
        }
        return def;
    }

    private List<Attachment> getAttachments(Issue issue, EmailDefinitionApi emailDefinition) {
        List<Attachment> attachments = new LinkedList<Attachment>();
        if (StringUtils.isNotBlank((String)emailDefinition.getAddAttachments())) {
            AddAttachmentType aat = AddAttachmentType.getByName(emailDefinition.getAddAttachments());
            if (aat != null) {
                attachments = aat.filterAttachments(issue, null);
            }
        } else if (emailDefinition.getAttachments() != null && !emailDefinition.getAttachments().isEmpty()) {
            HashSet<String> ids = new HashSet<String>(emailDefinition.getAttachments());
            for (Attachment a : issue.getAttachments()) {
                if (!ids.contains(a.getId().toString())) continue;
                attachments.add(a);
            }
        }
        return attachments;
    }

    private Template getEmailTemplate(String emailTemplate) {
        Template template = null;
        if (StringUtils.isNumeric((String)emailTemplate)) {
            try {
                Long id = Long.parseLong(emailTemplate);
                template = (Template)this.templateDao.getById(id);
            }
            catch (NumberFormatException id) {}
        } else {
            Template[] hits = (Template[])this.templateDao.filter("NAME = ?", new Object[]{emailTemplate});
            template = hits != null && hits.length > 0 ? hits[0] : null;
        }
        return template;
    }

    private Issue getIssue(String issueIdOrKey) {
        MutableIssue issue = null;
        issue = StringUtils.isNumeric((String)issueIdOrKey) ? this.issueManager.getIssueObject(Long.valueOf(Long.parseLong(issueIdOrKey))) : this.issueManager.getIssueObject(issueIdOrKey);
        return issue;
    }

    private String getUsersAndEmailAddresses(List<String> recipientTokens) {
        StringBuilder sb = new StringBuilder();
        if (recipientTokens != null && !recipientTokens.isEmpty()) {
            for (String token : recipientTokens) {
                Recipient.Type type = Recipient.Type.fromKey(token);
                if (type != null || !this.userResolver.isUser(token) && !this.userResolver.isEmailAddress(token) && !this.userResolver.isExtendedEmailAddress(token)) continue;
                if (this.userResolver.isExtendedEmailAddress(token)) {
                    token = this.userResolver.getEmailAddressFromExtendedAddress(token);
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(token);
            }
        }
        return sb.toString();
    }

    private List<Recipient> getRecipients(List<String> recipientTokens) {
        if (recipientTokens == null || recipientTokens.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Map<String, Recipient> recipientIndex = Recipient.buildRecipients(recipientTokens.toArray(new String[0]), this.customFieldManager, this.groupManager, this.projectRoleManager, this.authenticationContext.getI18nHelper());
        ArrayList<Recipient> recipients = new ArrayList<Recipient>(recipientIndex.values());
        Collections.sort(recipients);
        return recipients;
    }
}

