/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.rest;

import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.rest.CacheControls;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.StringUtil;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/auditlog")
public class EmailAuditLogResource {
    private Authorizer authorizer;
    private final AuditLogDao auditLogDao;

    public EmailAuditLogResource(Authorizer authorizer, AuditLogDao auditLogDao) {
        this.authorizer = authorizer;
        this.auditLogDao = auditLogDao;
    }

    @Path(value="/body/{emailId}")
    @GET
    @AnonymousAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response getEmailBody(@PathParam(value="emailId") Long emailId) {
        try {
            if (this.authorizer.authorize().isValid()) {
                AuditLogEntry ale;
                AuditLogEntry auditLogEntry = ale = emailId == null ? null : (AuditLogEntry)this.auditLogDao.getById(emailId);
                if (ale != null) {
                    return Response.ok((Object)StringUtil.removeScripts(ale.getEmailBody())).cacheControl(CacheControls.NO_CACHE).build();
                }
                throw new NotFoundException("Audit Log Entry Not found for ID");
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControls.NO_CACHE).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).cacheControl(CacheControls.NO_CACHE).build();
        }
    }
}

