/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.rest;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.rest.CacheControls;
import com.metainf.jira.plugin.emailissue.rest.CommentModel;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/comment")
public class CommentResource {
    private CommentManager commentManager;
    private IssueManager issueManager;
    private JiraAuthenticationContext authenticationContext;
    private DateTimeFormatterFactory dateTimeFormatterFactory;

    public CommentResource(CommentManager commentManager, IssueManager issueManager, JiraAuthenticationContext authenticationContext, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.commentManager = commentManager;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Path(value="/{issueId}/{commentId}")
    @GET
    public Response getCommentSource(@PathParam(value="issueId") Long issueId, @PathParam(value="commentId") Long commentId) {
        try {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            if (user == null) {
                throw new RuntimeException("User not logged in");
            }
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            if (issue == null) {
                throw new NotFoundException("Issue not found for ID: " + issueId);
            }
            Comment comment = this.selectComment(this.commentManager.getCommentsForUser((Issue)issue, user), commentId);
            CommentModel model = new CommentModel(comment, this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.COMPLETE).withDefaultLocale());
            return Response.ok((Object)model).cacheControl(CacheControls.NO_CACHE).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControls.NO_CACHE).build();
        }
    }

    private Comment selectComment(Collection<Comment> comments, Long commentId) {
        for (Comment c : comments) {
            if (!c.getId().equals(commentId)) continue;
            return c;
        }
        return null;
    }
}

