/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.rest;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.metainf.jira.plugin.emailissue.entity.CannedResponse;
import com.metainf.jira.plugin.emailissue.entity.CannedResponseDao;
import com.metainf.jira.plugin.emailissue.rest.CacheControls;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/response")
public class CannedResponseResource {
    private JiraAuthenticationContext authenticationContext;
    private final CannedResponseDao cannedResponseDao;

    public CannedResponseResource(CannedResponseDao cannedResponseDao, JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.cannedResponseDao = cannedResponseDao;
    }

    @Path(value="/{responseId}")
    @GET
    public Response getCommentSource(@PathParam(value="responseId") Long responseId, @QueryParam(value="jeditor") Boolean jEditor) {
        try {
            if (this.authenticationContext.getLoggedInUser() == null) {
                throw new RuntimeException("User not logged in");
            }
            CannedResponse response = (CannedResponse)this.cannedResponseDao.getById(responseId);
            String responseText = response != null ? response.getResponse() : "";
            responseText = Boolean.TRUE.equals(jEditor) ? responseText.replaceAll("\n", "<br />") : responseText;
            return Response.ok((Object)responseText).cacheControl(CacheControls.NO_CACHE).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControls.NO_CACHE).build();
        }
    }
}

