/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.queue;

import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.listener.EventQueueStats;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MailQueue {
    private Object lock = new Object();
    private final ConfigurationManager configurationManager;
    private boolean synchronousEventProcessing;
    private ScheduledThreadPoolExecutor eventExecutor;
    private static final EventQueueStats eventQueueStats = new EventQueueStats();
    public static final int DELAY_SECONDS = 30;
    private static final int MAX_WORKER_THREADS = 64;

    public MailQueue(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void schedule(Runnable runnable) {
        ScheduledThreadPoolExecutor executor = this.getEventExecutor();
        if (executor != null) {
            executor.schedule(runnable, 30L, TimeUnit.SECONDS);
        }
    }

    public boolean isSynchronousEventProcessing() {
        return this.getEventExecutor() != null;
    }

    public synchronized void setMaxWorkerThread(int maxThreads) {
        if (maxThreads > 0 && maxThreads <= 64) {
            if (this.eventExecutor != null) {
                maxThreads = Math.max(maxThreads, this.eventExecutor.getActiveCount());
                this.eventExecutor.setCorePoolSize(maxThreads);
                this.eventExecutor.setMaximumPoolSize(maxThreads);
            }
            this.synchronousEventProcessing = false;
        } else {
            this.synchronousEventProcessing = true;
        }
        Configuration configuration = this.configurationManager.getGlobalConfiguration();
        configuration.setMaxWorkerThreads(maxThreads);
        this.configurationManager.updateConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledThreadPoolExecutor getEventExecutor() {
        if (this.synchronousEventProcessing) {
            return null;
        }
        if (this.eventExecutor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.eventExecutor == null) {
                    Integer maxPoolSize = this.configurationManager.getGlobalConfiguration().getMaxWorkerThreads();
                    maxPoolSize = maxPoolSize == null ? 4 : maxPoolSize;
                    if (maxPoolSize > 0 && maxPoolSize <= 64) {
                        this.eventExecutor = new ScheduledThreadPoolExecutor(maxPoolSize);
                        this.eventExecutor.setMaximumPoolSize(maxPoolSize);
                    } else {
                        this.synchronousEventProcessing = true;
                    }
                }
            }
        }
        return this.eventExecutor;
    }

    public EventQueueStats getEventQueueStats() {
        if (this.eventExecutor != null) {
            eventQueueStats.update(this.eventExecutor.getCompletedTaskCount(), this.eventExecutor.getTaskCount(), this.eventExecutor.getQueue().size(), this.eventExecutor.getActiveCount(), this.synchronousEventProcessing ? 0 : this.eventExecutor.getMaximumPoolSize());
        }
        return eventQueueStats;
    }
}

