/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.panel;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.ApplicationProperties;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.audit.AuditLogBean;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import java.util.Date;
import java.util.Map;

public class EmailIssueAction
extends AbstractIssueAction {
    private final AuditLogBean auditLogBean;
    private final Issue issue;
    private final boolean allowedToSendEmail;

    public EmailIssueAction(Issue issue, IssueTabPanelModuleDescriptor descriptor, AuditLogEntry auditLogEntry, DateTimeFormatter dateTimeFormatter, I18nHelper i18nHelper, AvatarService avatarService, UserResolver userResolver, ApplicationProperties applicationProperties, TemplateDao templateDao, boolean allowedToSendEmail) {
        super(descriptor);
        this.issue = issue;
        this.allowedToSendEmail = allowedToSendEmail;
        this.auditLogBean = new AuditLogBean(issue, auditLogEntry, dateTimeFormatter, i18nHelper, avatarService, userResolver, applicationProperties, templateDao);
    }

    public Date getTimePerformed() {
        return this.auditLogBean.getAuditLogEntry().getSendTimeStamp();
    }

    protected void populateVelocityParams(Map map) {
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        map.put("audit", this.auditLogBean);
        map.put("baseUrl", baseUrl);
        map.put("entry", this.auditLogBean.getAuditLogEntry());
        map.put("issueTabPanel", Boolean.TRUE);
        map.put("allowedToSendEmail", new Boolean(this.allowedToSendEmail));
    }
}

