/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.panel;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.mail.MailFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.panel.EmailIssueAction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogPanel
extends AbstractIssueTabPanel2
implements IssueTabPanel2 {
    private static final Logger log = LoggerFactory.getLogger(AuditLogPanel.class);
    private final AuditLogDao auditLogDao;
    private final TemplateDao templateDao;
    private final DateTimeFormatter dateTimeFormatter;
    private final PermissionChecker jetiPermissionChecker;
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;
    private final UserResolver userResolver;
    private final ApplicationProperties applicationProperties;
    private final ConfigurationManager configurationManager;

    public AuditLogPanel(AuditLogDao auditLogDao, DateTimeFormatter dateTimeFormatter, TemplateDao templateDao, PermissionChecker jetiPermissionChecker, JiraAuthenticationContext authenticationContext, AvatarService avatarService, UserResolver userResolver, ApplicationProperties applicationProperties, ConfigurationManager configurationManager) {
        this.auditLogDao = auditLogDao;
        this.templateDao = templateDao;
        this.configurationManager = configurationManager;
        this.dateTimeFormatter = dateTimeFormatter.withStyle(DateTimeStyle.RELATIVE);
        this.jetiPermissionChecker = jetiPermissionChecker;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.userResolver = userResolver;
        this.applicationProperties = applicationProperties;
    }

    public ShowPanelReply showPanel(ShowPanelRequest showPanelRequest) {
        Configuration configuration = this.configurationManager.getGlobalConfiguration();
        if (configuration.getEmailLogDisplay() != null) {
            if (configuration.getEmailLogDisplay() == Configuration.EmailLogDisplayOption.ALWAYS) {
                return ShowPanelReply.create((boolean)true);
            }
            if (configuration.getEmailLogDisplay() == Configuration.EmailLogDisplayOption.HIDE) {
                return ShowPanelReply.create((boolean)false);
            }
            return ShowPanelReply.create((!showPanelRequest.isAnonymous() && this.jetiPermissionChecker.isAllowedToSendIssueInEmail(showPanelRequest.remoteUser(), showPanelRequest.issue()) ? 1 : 0) != 0);
        }
        boolean disabled = configuration.isEmailLogDisabled();
        return ShowPanelReply.create((!disabled && !showPanelRequest.isAnonymous() && this.jetiPermissionChecker.isAllowedToSendIssueInEmail(showPanelRequest.remoteUser(), showPanelRequest.issue()) ? 1 : 0) != 0);
    }

    public GetActionsReply getActions(GetActionsRequest request) {
        boolean allowedToSendEmail;
        Issue issue = request.issue();
        AuditLogEntry[] hits = (AuditLogEntry[])this.auditLogDao.filterAndOrder("ISSUE_ID = ?", "ID ASC", new Object[]{issue.getId()});
        ArrayList<EmailIssueAction> actionList = new ArrayList<EmailIssueAction>();
        MailSettings mailSettings = (MailSettings)ComponentAccessor.getComponent(MailSettings.class);
        boolean bl = allowedToSendEmail = !mailSettings.send().isDisabledViaApplicationProperty() && MailFactory.getServerManager().getDefaultSMTPMailServer() != null;
        if (allowedToSendEmail) {
            allowedToSendEmail = this.jetiPermissionChecker.isAllowedToSendIssueInEmail(ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser(), issue);
        }
        for (int i = 0; i < hits.length; ++i) {
            try {
                EmailIssueAction action = new EmailIssueAction(issue, this.descriptor(), hits[i], this.dateTimeFormatter.forLoggedInUser(), this.authenticationContext.getI18nHelper(), this.avatarService, this.userResolver, this.applicationProperties, this.templateDao, allowedToSendEmail);
                actionList.add(action);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GetActionsReply.create((IssueAction[])actionList.toArray(new EmailIssueAction[0]));
    }
}

