/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.operation;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.util.ArrayUtils;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PermissionCheckerImpl
implements PermissionChecker {
    private static transient Logger logger = Logger.getLogger((String)PermissionChecker.class.getName());
    private ProjectRoleManager prm;
    private GroupManager groupManager;
    private Authorizer authorizer;
    private ConfigurationManager configurationManager;
    private final IssueSearcher issueSearcher;
    private final PermissionManager permissionManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public PermissionCheckerImpl(GroupManager groupManager, ProjectRoleManager prm, Authorizer authorizer, ConfigurationManager configurationManager, IssueSearcher issueSearcher, PermissionManager permissionManager, IssueSecurityLevelManager issueSecurityLevelManager) {
        this.prm = prm;
        this.groupManager = groupManager;
        this.authorizer = authorizer;
        this.configurationManager = configurationManager;
        this.issueSearcher = issueSearcher;
        this.permissionManager = permissionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    @Override
    public boolean isAllowedToSendIssueInEmail(ApplicationUser user, Issue issue) {
        boolean allowed;
        if (!this.authorizer.authorize().isValid()) {
            logger.warn((Object)"Licence is invalid. Contact us at info@meta-inf.hu.");
            return false;
        }
        Configuration globalConfiguration = this.configurationManager.getGlobalConfiguration();
        String roleIds = globalConfiguration.getPermissionRoles();
        String groupNames = globalConfiguration.getPermissionGroups();
        boolean bl = allowed = StringUtils.isEmpty((String)roleIds) && StringUtils.isEmpty((String)groupNames) || this.isUserActorInRoles(user, roleIds, issue.getProjectObject()) || this.isUserMemberOfGroups(user, groupNames);
        if (allowed && StringUtils.isNotBlank((String)globalConfiguration.getJQLFilter())) {
            allowed = this.issueSearcher.issueMatchesJQLWithoutReindexing(globalConfiguration.getJQLFilter(), issue);
        }
        logger.debug((Object)("JETI operation allowed: " + allowed));
        return allowed;
    }

    private boolean isUserMemberOfGroups(ApplicationUser user, String groupNames) {
        String[] permissionGroups;
        if (StringUtils.isEmpty((String)groupNames)) {
            return false;
        }
        Collection userGroups = this.groupManager.getGroupNamesForUser(user);
        for (String group : permissionGroups = groupNames.split(",")) {
            if (!userGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    private boolean isUserActorInRoles(ApplicationUser user, String roleIds, Project project) {
        if (StringUtils.isEmpty((String)roleIds)) {
            return false;
        }
        HashSet<Long> projectRolePermissions = new HashSet<Long>(Arrays.asList(ArrayUtils.getLongArray(roleIds)));
        Collection roles = this.prm.getProjectRoles(user, project);
        for (ProjectRole role : roles) {
            if (projectRolePermissions.isEmpty() || !projectRolePermissions.contains(role.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllowedToViewIssue(ApplicationUser user, Issue issue) {
        boolean hasPermission = user != null && (issue == null || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user));
        boolean bl = hasPermission = hasPermission && this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue.getProjectObject(), user);
        if (hasPermission && issue.getSecurityLevelId() != null) {
            IssueSecurityLevel securityLevel = this.issueSecurityLevelManager.getSecurityLevel(issue.getSecurityLevelId().longValue());
            hasPermission = hasPermission && (securityLevel == null || this.issueSecurityLevelManager.getUsersSecurityLevels(issue, user).contains(securityLevel));
        }
        return hasPermission;
    }
}

