/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.operation;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractIssueWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmailIssueCondition
extends AbstractIssueWebCondition {
    private static transient Logger logger = Logger.getLogger((String)EmailIssueCondition.class.getName());
    private Authorizer authorizer;
    private PermissionChecker permissionChecker;

    public EmailIssueCondition(Authorizer authorizer, PermissionChecker jetiPermissionChecker) {
        this.authorizer = authorizer;
        this.permissionChecker = jetiPermissionChecker;
    }

    public boolean shouldDisplay(ApplicationUser user, Issue issue, JiraHelper jiraHelper) {
        Map params;
        logger.info((Object)"shouldDisplay called");
        if (!this.authorizer.authorize().isValid()) {
            return false;
        }
        if (issue == null && (issue = (Issue)(params = jiraHelper.getContextParams()).get("issue")) == null) {
            return false;
        }
        boolean visible = this.permissionChecker.isAllowedToSendIssueInEmail(user, issue);
        logger.info((Object)("shouldDisplay:" + visible));
        return visible;
    }

    public void init(Map config) throws PluginParseException {
        super.init(config);
    }
}

