/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailThreader;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.sal.api.ApplicationProperties;
import com.metainf.jira.plugin.emailissue.attachment.AttachmentContentProvider;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.mail.AttachmentDataSource;
import com.metainf.jira.plugin.emailissue.template.ImageURIResolver;
import com.metainf.jira.plugin.emailissue.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.text.MessageFormat;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SmartEmail
extends com.atlassian.jira.mail.Email {
    private static transient Logger logger = Logger.getLogger(SmartEmail.class);
    private int counter;
    private boolean multipartMixed;
    private final ApplicationProperties applicationProperties;
    private final ImageURIResolver imageURIResolver;
    private static final String ATTACHMENT_LINK = "{0}/secure/attachment/{1}/{1}_{2}";
    private static final String THUMBNAIL_LINK = "{0}/secure/thumbnail/{1}/_thumb_{1}.{2}";
    private static final String DIRECT_ATTACHMENT_LINK = "{0}/secure/attachment/{1}/{2}";
    private static final String DIRECT_ATTACHMENT_ID_LINK = "{0}/secure/attachment/{1}/{1}";
    private static final String JEDITOR_ATTACHMENT_LINK = "{0}/plugins/servlet/jeditor_attached_image_provider?attachName={1}&amp;issueId={2}&amp;thumb=false&amp;mime={3}";

    public SmartEmail(String to, String cc, String bcc, ApplicationProperties applicationProperties, Configuration globalConfiguration) {
        super(to, cc, bcc);
        this.applicationProperties = applicationProperties;
        this.imageURIResolver = new ImageURIResolver(this.applicationProperties.getBaseUrl());
        this.multipartMixed = Boolean.TRUE.equals(globalConfiguration.isMultipartMixed());
    }

    public void send(MailThreader mailThreader) {
        SingleMailQueueItem item = new SingleMailQueueItem((Email)this);
        item.setMailThreader(mailThreader);
        ComponentAccessor.getMailQueue().addItem((MailQueueItem)item);
    }

    public void addAttachment(Attachment att, AttachmentContentProvider attachmentContentProvider) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AddAttachment: " + att.getFilename() + ", " + att.getMimetype()));
            }
            AttachmentDataSource source = new AttachmentDataSource(attachmentContentProvider, att);
            MimeBodyPart part = this.createPart(source, att.getFilename());
            if (att.getMimetype() != null && att.getMimetype().toLowerCase().contains("image/")) {
                boolean inlineJEditorAttachment;
                String body = this.getEmailBodyText();
                String attachmentLink = this.reconstructAttachmentLink(ATTACHMENT_LINK, this.applicationProperties.getBaseUrl(), att);
                String thumbnailLink = this.reconstructThumbnailLink(THUMBNAIL_LINK, this.applicationProperties.getBaseUrl(), att);
                String directAttachmentLink = this.reconstructAttachmentLink(DIRECT_ATTACHMENT_LINK, this.applicationProperties.getBaseUrl(), att);
                String directAttachmentIdLink = this.reconstructAttachmentLink(DIRECT_ATTACHMENT_ID_LINK, this.applicationProperties.getBaseUrl(), att);
                String jEditorLink = this.reconstructJEditorAttachmentLink(this.applicationProperties.getBaseUrl(), att);
                boolean inlineAttachment = body != null && body.contains(attachmentLink);
                boolean inlineThumbnail = body != null && body.contains(thumbnailLink);
                boolean inlineDirectAttachment = body != null && body.contains(directAttachmentLink);
                boolean inlineDirectAttachmentId = body != null && body.contains(directAttachmentIdLink);
                boolean bl = inlineJEditorAttachment = body != null && body.contains(jEditorLink);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attachment link: " + attachmentLink + "(" + inlineAttachment + ")"));
                    logger.debug((Object)("Direct Attachment link: " + directAttachmentLink + "(" + inlineDirectAttachment + ")"));
                    logger.debug((Object)("jEditor link: " + jEditorLink + "(" + inlineJEditorAttachment + ")"));
                }
                if (inlineAttachment || inlineThumbnail || inlineDirectAttachment || inlineJEditorAttachment || inlineDirectAttachmentId) {
                    String cid = this.cid();
                    this.addInlinePart(part, cid);
                    if (inlineAttachment) {
                        this.referImageLinkToPart(attachmentLink, cid);
                    }
                    if (inlineThumbnail) {
                        this.referImageLinkToPart(thumbnailLink, cid);
                    }
                    if (inlineDirectAttachment) {
                        this.referImageLinkToPart(directAttachmentLink, cid);
                    }
                    if (inlineDirectAttachmentId) {
                        this.referImageLinkToPart(directAttachmentIdLink, cid);
                    }
                    if (inlineJEditorAttachment) {
                        this.referImageLinkToPart(jEditorLink, cid);
                    }
                } else {
                    this.attach(part);
                }
            } else {
                this.attach(part);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void attach(MimeBodyPart part) {
        try {
            part.setDisposition("attachment");
            this.getEmailMultipart().addBodyPart((BodyPart)part);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void inline(MimeBodyPart part, String link) {
        try {
            String cid = this.cid();
            this.addInlinePart(part, cid);
            this.referImageLinkToPart(link, cid);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void referImageLinkToPart(String link, String cid) {
        String body = this.getEmailBodyText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Image link being changed to refer to Part: " + link + " (body contains link: " + body.contains(link) + ")"));
        }
        body = StringUtil.replaceInTags("<img", body, link, String.format("cid:%s", cid));
        this.setBody(body);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Body contains link after replace: " + body.contains(link)));
        }
    }

    private String cid() {
        SecureRandom random = new SecureRandom();
        String cid = this.counter++ + "." + Math.abs(random.nextLong()) + "@meta-inf.hu";
        return cid;
    }

    private void addInlinePart(MimeBodyPart part, String cid) throws MessagingException {
        part.removeHeader("Content-ID");
        part.addHeader("Content-ID", "<" + cid + ">");
        part.setDisposition("inline");
        this.getEmailMultipart().addBodyPart((BodyPart)part);
    }

    private MimeBodyPart createPart(DataSource source, String fileName) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(new DataHandler(source));
        String mailEncodeFilename = System.getProperty("mail.mime.encodefilename");
        if (Boolean.valueOf(mailEncodeFilename).booleanValue()) {
            part.setFileName(fileName);
        } else {
            part.setFileName(fileName);
        }
        return part;
    }

    public void attachOrInline(String fileName, String attachmentLink, DataSource source) {
        try {
            logger.info((Object)("attachOrInline: " + fileName + ", " + attachmentLink));
            MimeBodyPart part = this.createPart(source, fileName);
            String body = this.getEmailBodyText();
            if (body.contains(attachmentLink)) {
                this.inline(part, attachmentLink);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Image being inlined: " + fileName));
                    logger.debug((Object)("Created MimeBodyPart from attachment: " + part));
                }
            } else if (part != null) {
                this.attach(part);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Image being attached: " + fileName));
                    logger.debug((Object)("Created MimeBodyPart from attachment: " + part));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected String reconstructJEditorAttachmentLink(String baseUrl, Attachment att) {
        String contextPath = "/".equals(baseUrl) ? "" : baseUrl;
        String attachmentName = att.getFilename();
        try {
            attachmentName = URLEncoder.encode(attachmentName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return MessageFormat.format(JEDITOR_ATTACHMENT_LINK, contextPath, attachmentName, att.getIssueObject().getId().toString(), att.getMimetype().toLowerCase());
    }

    protected String reconstructThumbnailLink(String linkPattern, String baseUrl, Attachment att) {
        String contextPath = "/".equals(baseUrl) ? "" : baseUrl;
        String extension = "png";
        return MessageFormat.format(linkPattern, contextPath, att.getId().toString(), extension);
    }

    protected String reconstructAttachmentLink(String linkPattern, String baseUrl, Attachment att) {
        String contextPath = "/".equals(baseUrl) ? "" : baseUrl;
        String attachmentName = att.getFilename();
        try {
            attachmentName = URLEncoder.encode(attachmentName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return MessageFormat.format(linkPattern, contextPath, att.getId().toString(), attachmentName);
    }

    protected String getAbsolutePath(Attachment att) {
        File file = AttachmentUtils.getAttachmentFile((Attachment)att);
        return file == null || !file.exists() ? null : file.getAbsolutePath();
    }

    public Multipart getEmailMultipart() {
        if (super.getMultipart() == null) {
            if (this.multipartMixed) {
                this.setMultipart((Multipart)new MimeMultipart("mixed"));
            } else {
                this.setMultipart((Multipart)new MimeMultipart("related"));
            }
        }
        return super.getMultipart();
    }

    protected String getEmailBodyText() {
        try {
            if (StringUtils.isBlank((String)this.getBody()) && this.getMultipart() != null && this.getMultipart().getCount() > 0) {
                BodyPart bodyPart = this.getMultipart().getBodyPart(0);
                return bodyPart == null || bodyPart.getContent() == null ? this.getBody() : bodyPart.getContent().toString();
            }
            return this.getBody();
        }
        catch (IOException | MessagingException e) {
            return this.getBody();
        }
    }
}

