/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.mail;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.action.EmailBuilder;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EmailSenderImpl
implements EmailSender {
    private static transient Logger logger = Logger.getLogger(EmailSenderImpl.class);
    private final ThreadPoolExecutor emailExecutor;
    private final EmailBuilder emailBuilder;
    private final JiraAuthenticationContext jac;

    public EmailSenderImpl(EmailBuilder emailBuilder, JiraAuthenticationContext jac) {
        this.emailBuilder = emailBuilder;
        this.jac = jac;
        int coreThreads = 2;
        int maxThreads = 4;
        this.emailExecutor = new ThreadPoolExecutor(coreThreads, maxThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void sendEmail(EmailDefinition def, ApplicationUser remoteUser) throws Exception {
        this.emailBuilder.sendEmail(def, remoteUser);
    }

    @Override
    public void sendEmailWithUserEditedSubject(EmailDefinition def, String emailSubject, ApplicationUser remoteUser) throws Exception {
        this.emailBuilder.sendEmailWithUserEditedSubject(def, emailSubject, remoteUser);
    }

    @Override
    public void sendEmailAsync(EmailDefinition def, ApplicationUser remoteUser) throws Exception {
        this.sendEmailWithUserEditedSubjectAsync(def, null, remoteUser);
    }

    @Override
    public void sendEmailWithUserEditedSubjectAsync(EmailDefinition def, String emailSubject, ApplicationUser remoteUser) throws Exception {
        this.sendEmailWithUserEditedSubject(def, emailSubject, remoteUser);
    }
}

