/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.mail;

import com.atlassian.mail.MailUtils;
import com.metainf.jira.plugin.emailissue.entity.FieldRule;
import com.metainf.jira.plugin.emailissue.handler.MailUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

public class EmailBean {
    private String subject;
    private String body;
    private String[] recipients;
    private String senderEmailAddress;
    private String senderName;
    private Map<String, String[]> emailHeaders = new HashMap<String, String[]>();

    public EmailBean(Message message) throws MessagingException {
        this.body = MailUtils.getBody((Message)message);
        this.subject = message.getSubject();
        HashSet<String> senderEmailAddressesInLowerCase = MailUtil.getSendersInLowerCase(message);
        HashSet<String> recipientEmailAddresses = MailUtil.getEmailAddresses(message, Message.RecipientType.TO);
        recipientEmailAddresses.addAll(MailUtil.getEmailAddresses(message, Message.RecipientType.CC));
        this.recipients = recipientEmailAddresses == null || recipientEmailAddresses.isEmpty() ? new String[]{} : recipientEmailAddresses.toArray(new String[0]);
        String string = this.senderEmailAddress = senderEmailAddressesInLowerCase == null || senderEmailAddressesInLowerCase.isEmpty() ? null : (String)senderEmailAddressesInLowerCase.iterator().next();
        if (message.getFrom() != null && message.getFrom().length > 0 && message.getFrom()[0] instanceof InternetAddress) {
            this.senderName = ((InternetAddress)message.getFrom()[0]).getPersonal();
        }
        Enumeration en = message.getAllHeaders();
        while (en.hasMoreElements()) {
            Header header = (Header)en.nextElement();
            String[] headerValue = message.getHeader(header.getName());
            if (headerValue == null || headerValue.length <= 0) continue;
            this.emailHeaders.put(header.getName(), headerValue);
        }
    }

    public String[] get(FieldRule fieldRule) {
        switch (fieldRule.getEmailField()) {
            case BODY: {
                return new String[]{this.getBody()};
            }
            case SUBJECT: {
                return new String[]{this.subject};
            }
            case RECIPIENTS: {
                return this.recipients;
            }
            case SENDER: {
                return new String[]{this.senderEmailAddress};
            }
            case SENDER_NAME: {
                return new String[]{this.senderName};
            }
            case HEADER: {
                return this.emailHeaders.get(fieldRule.getEmailHeaderName());
            }
        }
        return new String[0];
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public String[] getRecipients() {
        return this.recipients;
    }

    public String getSenderEmailAddress() {
        return this.senderEmailAddress;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public Map<String, String[]> getEmailHeaders() {
        return this.emailHeaders;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }
}

