/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.mail;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.AttachmentUtils;
import com.metainf.jira.plugin.emailissue.attachment.AttachmentContentProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class AttachmentDataSource
implements DataSource {
    private final AttachmentContentProvider attachmentContentProvider;
    private final Attachment attachment;
    private FileDataSource fileDataSource;

    public AttachmentDataSource(AttachmentContentProvider attachmentContentProvider, Attachment attachment) {
        if (attachmentContentProvider == null) {
            String path = this.getAbsolutePath(attachment);
            this.fileDataSource = new FileDataSource(path);
        }
        this.attachmentContentProvider = attachmentContentProvider;
        this.attachment = attachment;
    }

    public InputStream getInputStream() throws IOException {
        return this.fileDataSource != null ? this.fileDataSource.getInputStream() : this.attachmentContentProvider.getAttachmentContent(this.attachment);
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public String getContentType() {
        return this.fileDataSource != null ? this.fileDataSource.getContentType() : this.attachment.getMimetype();
    }

    public String getName() {
        return this.fileDataSource != null ? this.fileDataSource.getName() : this.attachment.getFilename();
    }

    protected String getAbsolutePath(Attachment att) {
        File file = AttachmentUtils.getAttachmentFile((Attachment)att);
        return file == null || !file.exists() ? null : file.getAbsolutePath();
    }
}

