/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.mail;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.action.EmailBuilder;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class AsynEmailSender
implements Runnable {
    private static transient Logger logger = Logger.getLogger(AsynEmailSender.class);
    private final ApplicationUser user;
    private final EmailDefinition emailDefinition;
    private final String emailSubject;
    private final JiraAuthenticationContext jac;
    private final EmailBuilder emailBuilder;

    @Override
    public void run() {
        try {
            this.jac.setLoggedInUser(this.user);
            this.emailBuilder.sendEmailWithUserEditedSubject(this.emailDefinition, this.emailSubject, this.user);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.jac.setLoggedInUser((ApplicationUser)null);
        }
    }

    public AsynEmailSender(@Nonnull ApplicationUser user, @Nonnull EmailDefinition emailDefinition, String emailSubject, @Nonnull JiraAuthenticationContext jac, EmailBuilder emailBuilder) {
        this.user = user;
        this.emailDefinition = emailDefinition;
        this.emailSubject = emailSubject;
        this.jac = jac;
        this.emailBuilder = emailBuilder;
    }
}

