/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.events.EventProcessor;
import com.metainf.jira.plugin.emailissue.listener.AsyncEventProcessor;
import com.metainf.jira.plugin.emailissue.listener.EventQueueStats;
import com.metainf.jira.plugin.emailissue.queue.MailQueue;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.workflow.AsyncPostFunctionExecutor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class IssueEventListener
implements InitializingBean,
DisposableBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private final EventPublisher eventPublisher;
    private final Authorizer authorizer;
    private final EventProcessor eventProcessor;
    private final ConfigurationManager configurationManager;
    private static MailQueue mailQueue;
    private static boolean synchronousEventProcessing;
    private static ScheduledThreadPoolExecutor eventExecutor;
    private static final EventQueueStats eventQueueStats;
    public static final int DELAY_SECONDS = 30;
    private static final int MAX_WORKER_THREADS = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IssueEventListener(EventProcessor eventProcessor, EventPublisher eventPublisher, Authorizer authorizer, ConfigurationManager configurationManager) {
        this.eventPublisher = eventPublisher;
        this.eventProcessor = eventProcessor;
        this.authorizer = authorizer;
        this.configurationManager = configurationManager;
        if (mailQueue != null) return;
        Class<IssueEventListener> clazz = IssueEventListener.class;
        synchronized (IssueEventListener.class) {
            if (mailQueue != null) return;
            mailQueue = new MailQueue(this.configurationManager);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent issueEvent) {
        try {
            if (!issueEvent.isSendMail()) {
                return;
            }
            if (!this.authorizer.authorize().isValid()) {
                this.logger.warn((Object)"Email This Issue license is invalid. Please contact info@meta-inf.hu ");
                return;
            }
            ScheduledThreadPoolExecutor executor = this.getEventExecutor();
            if (executor != null) {
                AsyncEventProcessor asyncEventProcessor = new AsyncEventProcessor(this.eventProcessor, issueEvent, issueEvent.getUser(), ComponentAccessor.getJiraAuthenticationContext(), eventQueueStats);
                executor.schedule(asyncEventProcessor, 30L, TimeUnit.SECONDS);
            } else {
                this.eventProcessor.processIssueEventSynchronously(issueEvent);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onPostFunction(AsyncPostFunctionExecutor asyncPostFunctionExecutor) {
        ScheduledThreadPoolExecutor executor = this.getEventExecutor();
        if (executor != null) {
            executor.schedule(asyncPostFunctionExecutor, 30L, TimeUnit.SECONDS);
        } else {
            asyncPostFunctionExecutor.executeSynchronously();
        }
    }

    public void setMaxWorkerThread(int maxThreads) {
        if (maxThreads > 0 && maxThreads <= 64) {
            if (eventExecutor != null) {
                maxThreads = Math.max(maxThreads, eventExecutor.getActiveCount());
                eventExecutor.setCorePoolSize(maxThreads);
                eventExecutor.setMaximumPoolSize(maxThreads);
            }
            synchronousEventProcessing = false;
        } else {
            synchronousEventProcessing = true;
        }
        Configuration configuration = this.configurationManager.getGlobalConfiguration();
        configuration.setMaxWorkerThreads(maxThreads);
        this.configurationManager.updateConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledThreadPoolExecutor getEventExecutor() {
        if (synchronousEventProcessing) {
            return null;
        }
        if (eventExecutor == null) {
            EventQueueStats eventQueueStats = IssueEventListener.eventQueueStats;
            synchronized (eventQueueStats) {
                if (eventExecutor == null) {
                    Integer maxPoolSize = this.configurationManager.getGlobalConfiguration().getMaxWorkerThreads();
                    maxPoolSize = maxPoolSize == null ? 4 : maxPoolSize;
                    if (maxPoolSize > 0 && maxPoolSize <= 64) {
                        eventExecutor = new ScheduledThreadPoolExecutor(maxPoolSize);
                        eventExecutor.setMaximumPoolSize(maxPoolSize);
                    } else {
                        synchronousEventProcessing = true;
                    }
                }
            }
        }
        return eventExecutor;
    }

    public EventQueueStats getEventQueueStats() {
        if (eventExecutor != null) {
            eventQueueStats.update(eventExecutor.getCompletedTaskCount(), eventExecutor.getTaskCount(), eventExecutor.getQueue().size(), eventExecutor.getActiveCount(), synchronousEventProcessing ? 0 : eventExecutor.getMaximumPoolSize());
        }
        return eventQueueStats;
    }

    static {
        eventQueueStats = new EventQueueStats();
    }
}

