/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.listener;

import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.metainf.jira.plugin.emailissue.listener.AsyncEventProcessor;
import org.apache.log4j.Logger;

public class EventQueueStats {
    private static Logger logger = Logger.getLogger(EventQueueStats.class);
    private long timeInQueue;
    private long avgTimeInQueue;
    private int updateCount = 0;
    private long completedTaskCount;
    private long taskCount;
    private int queueSize;
    private int activeCount;
    private int maximumPoolSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(AsyncEventProcessor mqi) {
        EventQueueStats eventQueueStats = this;
        synchronized (eventQueueStats) {
            this.timeInQueue = System.currentTimeMillis() - mqi.getTimeEnqueued() - 30000L;
            this.avgTimeInQueue = this.updateCount < 100 ? (this.avgTimeInQueue * (long)this.updateCount + this.timeInQueue) / (long)(++this.updateCount) : (this.avgTimeInQueue * (long)(this.updateCount - 1) + this.timeInQueue) / (long)this.updateCount;
        }
    }

    public String toString() {
        return String.format("Executor stats: " + this.toJson().toString(), new Object[0]);
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        try {
            result.put("timeInQueue", this.timeInQueue);
            result.put("totalCompleted", this.completedTaskCount);
            result.put("totalQueued", this.taskCount);
            result.put("queueSize", this.queueSize);
            result.put("activeWorkers", this.activeCount);
            result.put("maxWorkers", this.maximumPoolSize);
            result.put("avgTimeInQueue", this.avgTimeInQueue);
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public long getTimeInQueue() {
        return this.timeInQueue;
    }

    public long getAvgTimeInQueue() {
        return this.avgTimeInQueue;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public long getTaskCount() {
        return this.taskCount;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long completedTaskCount, long taskCount, int queueSize, int activeCount, int maximumPoolSize) {
        EventQueueStats eventQueueStats = this;
        synchronized (eventQueueStats) {
            this.completedTaskCount = completedTaskCount;
            this.taskCount = taskCount;
            this.queueSize = queueSize;
            this.activeCount = activeCount;
            this.maximumPoolSize = maximumPoolSize;
        }
    }
}

